/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.OWLObjectDuplicator;

public class CoerceConstantsIntoDataPropertyRange
extends AbstractCompositeOntologyChange {
    private Map<OWLDataPropertyExpression, OWLDataType> map;
    private List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();

    public CoerceConstantsIntoDataPropertyRange(OWLDataFactory dataFactory, Set<OWLOntology> ontologies) {
        super(dataFactory);
        this.map = new HashMap<OWLDataPropertyExpression, OWLDataType>();
        for (OWLOntology ont : ontologies) {
            for (OWLDataPropertyRangeAxiom ax : ont.getAxioms(AxiomType.DATA_PROPERTY_RANGE)) {
                if (!((OWLDataRange)ax.getRange()).isDataType()) continue;
                this.map.put((OWLDataPropertyExpression)ax.getProperty(), (OWLDataType)ax.getRange());
            }
        }
        OWLConstantReplacer replacer = new OWLConstantReplacer(this.getDataFactory());
        for (OWLOntology ont : ontologies) {
            for (OWLLogicalAxiom ax : ont.getLogicalAxioms()) {
                OWLAxiom dupAx;
                if (ax.equals(dupAx = (OWLAxiom)replacer.duplicateObject(ax))) continue;
                this.changes.add(new RemoveAxiom(ont, ax));
                this.changes.add(new AddAxiom(ont, dupAx));
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }

    private class OWLConstantReplacer
    extends OWLObjectDuplicator {
        public OWLConstantReplacer(OWLDataFactory dataFactory) {
            super(dataFactory);
        }

        private OWLDataOneOf process(OWLDataPropertyExpression prop, OWLDataOneOf oneOf) {
            HashSet<OWLConstant> vals = new HashSet<OWLConstant>();
            for (OWLConstant con : oneOf.getValues()) {
                vals.add(this.process(prop, con));
            }
            return CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataOneOf(vals);
        }

        private OWLConstant process(OWLDataPropertyExpression prop, OWLConstant con) {
            OWLDataType dt = (OWLDataType)CoerceConstantsIntoDataPropertyRange.this.map.get(prop);
            if (dt != null) {
                return CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLTypedConstant(con.getLiteral(), dt);
            }
            return con;
        }

        @Override
        public void visit(OWLDataValueRestriction desc) {
            super.visit(desc);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataValueRestriction((OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLConstant)desc.getValue())));
        }

        @Override
        public void visit(OWLDataSomeRestriction desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataSomeRestriction((OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataMinCardinalityRestriction desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataMinCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), desc.getCardinality(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataMaxCardinalityRestriction desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), desc.getCardinality(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataExactCardinalityRestriction desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataExactCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), desc.getCardinality(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataAllRestriction desc) {
            super.visit(desc);
            if (desc instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataAllRestriction((OWLDataPropertyExpression)desc.getProperty(), this.process((OWLDataPropertyExpression)desc.getProperty(), (OWLDataOneOf)desc.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            super.visit(axiom);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataPropertyAssertionAxiom(axiom.getSubject(), (OWLDataPropertyExpression)axiom.getProperty(), this.process((OWLDataPropertyExpression)axiom.getProperty(), (OWLConstant)axiom.getObject())));
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            super.visit(axiom);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLNegativeDataPropertyAssertionAxiom(axiom.getSubject(), (OWLDataPropertyExpression)axiom.getProperty(), this.process((OWLDataPropertyExpression)axiom.getProperty(), (OWLConstant)axiom.getObject())));
        }
    }
}

