/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.RemoveAxiom;

public class ConvertPropertyAssertionsToAnnotations
extends AbstractCompositeOntologyChange {
    private Set<OWLOntology> ontologies;
    private List<OWLOntologyChange> changes;

    public ConvertPropertyAssertionsToAnnotations(OWLDataFactory dataFactory, Set<OWLOntology> ontologies) {
        super(dataFactory);
        this.ontologies = ontologies;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        for (OWLOntology ont : this.ontologies) {
            individuals.addAll(ont.getReferencedIndividuals());
        }
        HashSet<OWLDataProperty> convertedDataProperties = new HashSet<OWLDataProperty>();
        for (OWLIndividual ind : individuals) {
            boolean punned = false;
            for (OWLOntology ont : this.ontologies) {
                if (!ont.containsClassReference(ind.getURI())) continue;
                punned = true;
                break;
            }
            if (!punned) continue;
            for (OWLOntology ont : this.ontologies) {
                for (OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom : ont.getDataPropertyAssertionAxioms(ind)) {
                    if (((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty()).isAnonymous()) continue;
                    this.changes.add(new RemoveAxiom(ont, oWLDataPropertyAssertionAxiom));
                    OWLDataFactory df = this.getDataFactory();
                    OWLConstantAnnotation anno = df.getOWLConstantAnnotation(((OWLDataProperty)oWLDataPropertyAssertionAxiom.getProperty()).getURI(), (OWLConstant)oWLDataPropertyAssertionAxiom.getObject());
                    OWLEntityAnnotationAxiom annoAx = df.getOWLEntityAnnotationAxiom(df.getOWLClass(ind.getURI()), anno);
                    this.changes.add(new AddAxiom(ont, annoAx));
                    convertedDataProperties.add((OWLDataProperty)oWLDataPropertyAssertionAxiom.getProperty());
                }
            }
            for (OWLOntology ont : this.ontologies) {
                for (OWLDeclarationAxiom oWLDeclarationAxiom : ont.getDeclarationAxioms(ind)) {
                    this.changes.add(new RemoveAxiom(ont, oWLDeclarationAxiom));
                }
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ont.getClassAssertionAxioms(ind)) {
                    this.changes.add(new RemoveAxiom(ont, oWLClassAssertionAxiom));
                }
            }
        }
        for (OWLDataProperty prop : convertedDataProperties) {
            for (OWLOntology ont : this.ontologies) {
                for (OWLDeclarationAxiom oWLDeclarationAxiom : ont.getDeclarationAxioms(prop)) {
                    this.changes.add(new RemoveAxiom(ont, oWLDeclarationAxiom));
                }
                for (OWLDataPropertyAxiom oWLDataPropertyAxiom : ont.getAxioms(prop)) {
                    this.changes.add(new RemoveAxiom(ont, oWLDataPropertyAxiom));
                }
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

