/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.RemoveAxiom;

public class ConvertSuperClassesToEquivalentClass
extends AbstractCompositeOntologyChange {
    private OWLOntology targetOntology;
    private OWLClass cls;
    private Set<OWLOntology> ontologies;
    private List<OWLOntologyChange> changes;

    public ConvertSuperClassesToEquivalentClass(OWLDataFactory dataFactory, OWLClass cls, Set<OWLOntology> ontologies, OWLOntology targetOntology) {
        super(dataFactory);
        this.targetOntology = targetOntology;
        this.cls = cls;
        this.ontologies = ontologies;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLSubClassAxiom ax : ont.getSubClassAxiomsForLHS(this.cls)) {
                this.changes.add(new RemoveAxiom(ont, ax));
                descs.add(ax.getSuperClass());
            }
        }
        OWLObjectIntersectionOf equivalentClass = this.getDataFactory().getOWLObjectIntersectionOf(descs);
        HashSet<OWLDescription> equivalentClasses = new HashSet<OWLDescription>();
        equivalentClasses.add(this.cls);
        equivalentClasses.add(equivalentClass);
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLEquivalentClassesAxiom(equivalentClasses)));
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

