/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;

public class CreateValuePartition
extends AbstractCompositeOntologyChange {
    private List<OWLOntologyChange> changes;
    private OWLOntology targetOntology;
    private Set<OWLClass> valuePartionClasses;
    private OWLClass valuePartitionClass;
    private OWLObjectProperty valuePartitionProperty;

    public CreateValuePartition(OWLDataFactory dataFactory, OWLClass valuePartitionClass, Set<OWLClass> valuePartionClasses, OWLObjectProperty valuePartitionProperty, OWLOntology targetOntology) {
        super(dataFactory);
        this.targetOntology = targetOntology;
        this.valuePartionClasses = valuePartionClasses;
        this.valuePartitionClass = valuePartitionClass;
        this.valuePartitionProperty = valuePartitionProperty;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        for (OWLClass valuePartitionValue : this.valuePartionClasses) {
            this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLSubClassAxiom(valuePartitionValue, this.valuePartitionClass)));
        }
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(this.valuePartionClasses)));
        OWLObjectUnionOf union = this.getDataFactory().getOWLObjectUnionOf(this.valuePartionClasses);
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLSubClassAxiom(this.valuePartitionClass, union)));
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLFunctionalObjectPropertyAxiom(this.valuePartitionProperty)));
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLObjectPropertyRangeAxiom(this.valuePartitionProperty, this.valuePartitionClass)));
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

