/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.debugging;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.debugging.AbstractOWLDebugger;
import org.semanticweb.owl.inference.OWLSatisfiabilityChecker;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.OWLEntityCollector;
import org.semanticweb.owl.util.SimpleURIMapper;

public class BlackBoxOWLDebugger
extends AbstractOWLDebugger {
    private static final Logger logger = Logger.getLogger(BlackBoxOWLDebugger.class.getName());
    private OWLOntologyManager owlOntologyManager;
    private OWLClass currentClass;
    private OWLOntology debuggingOntology;
    private Set<OWLAxiom> debuggingAxioms;
    private Set<OWLEntity> objectsExpandedWithDefiningAxioms;
    private Set<OWLEntity> objectsExpandedWithReferencingAxioms;
    private Set<OWLAxiom> expandedWithDefiningAxioms;
    private Set<OWLAxiom> expandedWithReferencingAxioms;
    private OWLSatisfiabilityChecker reasoner;
    private Set<OWLAxiom> temporaryAxioms;
    private Map<OWLAxiom, OWLAxiom> expandedAxiomMap;
    public static final int DEFAULT_INITIAL_EXPANSION_LIMIT = 50;
    private int initialExpansionLimit;
    private int expansionLimit;
    private double expansionFactor;
    private static final int DEFAULT_FAST_PRUNING_WINDOW_SIZE = 10;
    private int fastPruningWindowSize;
    private boolean performRepeatedFastPruning;
    private int satTestCount;
    int ontologyCounter;

    public BlackBoxOWLDebugger(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLSatisfiabilityChecker reasoner) {
        super(owlOntologyManager, ontology);
        this.expansionLimit = this.initialExpansionLimit = 50;
        this.expansionFactor = 1.25;
        this.fastPruningWindowSize = 0;
        this.performRepeatedFastPruning = false;
        this.satTestCount = 0;
        this.ontologyCounter = 0;
        this.owlOntologyManager = owlOntologyManager;
        this.reasoner = reasoner;
        this.debuggingAxioms = new LinkedHashSet<OWLAxiom>();
        this.objectsExpandedWithDefiningAxioms = new HashSet<OWLEntity>();
        this.objectsExpandedWithReferencingAxioms = new HashSet<OWLEntity>();
        this.expandedWithDefiningAxioms = new HashSet<OWLAxiom>();
        this.expandedWithReferencingAxioms = new HashSet<OWLAxiom>();
        this.temporaryAxioms = new HashSet<OWLAxiom>();
        this.expandedAxiomMap = new HashMap<OWLAxiom, OWLAxiom>();
        logger.setLevel(Level.INFO);
    }

    @Override
    public void dispose() {
        try {
            this.reset();
            this.reasoner.dispose();
        }
        catch (OWLException e) {
            logger.throwing(this.getClass().getName(), "dispose", e);
        }
    }

    private void reset() {
        this.currentClass = null;
        this.debuggingOntology = null;
        this.debuggingAxioms.clear();
        this.objectsExpandedWithDefiningAxioms.clear();
        this.objectsExpandedWithReferencingAxioms.clear();
        this.expandedWithDefiningAxioms.clear();
        this.expandedWithReferencingAxioms.clear();
        this.temporaryAxioms.clear();
        this.expandedAxiomMap.clear();
        this.expansionLimit = this.initialExpansionLimit;
    }

    @Override
    protected OWLDescription getCurrentClass() throws OWLException {
        return this.currentClass;
    }

    private OWLClass setupDebuggingClass(OWLDescription cls) throws OWLException {
        if (!cls.isAnonymous()) {
            return (OWLClass)cls;
        }
        OWLClass curCls = this.owlOntologyManager.getOWLDataFactory().getOWLClass(BlackBoxOWLDebugger.createURI());
        HashSet<OWLDescription> operands = new HashSet<OWLDescription>();
        operands.add(curCls);
        operands.add(cls);
        this.temporaryAxioms.add(this.owlOntologyManager.getOWLDataFactory().getOWLEquivalentClassesAxiom(operands));
        for (OWLAxiom ax : this.temporaryAxioms) {
            this.owlOntologyManager.applyChanges(Arrays.asList(new AddAxiom(this.getOWLOntology(), ax)));
        }
        return curCls;
    }

    @Override
    public Set<OWLAxiom> getSOSForIncosistentClass(OWLDescription cls) throws OWLException {
        this.reset();
        this.currentClass = this.setupDebuggingClass(cls);
        this.generateSOSAxioms();
        for (OWLAxiom ax : this.temporaryAxioms) {
            this.owlOntologyManager.applyChanges(Arrays.asList(new RemoveAxiom(this.getOWLOntology(), ax)));
        }
        this.debuggingAxioms.removeAll(this.temporaryAxioms);
        this.ontologyCounter = 0;
        return new HashSet<OWLAxiom>(this.debuggingAxioms);
    }

    private static List<OWLAxiom> toList(Set<OWLAxiom> axioms) {
        return new ArrayList<OWLAxiom>(axioms);
    }

    private int expandAxioms() throws OWLException {
        int added;
        OWLEntityCollector collector;
        int axiomsAdded = 0;
        int remainingSpace = this.expansionLimit;
        for (OWLAxiom ax : new HashSet<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithDefiningAxioms.contains(ax)) continue;
            collector = new OWLEntityCollector();
            ax.accept(collector);
            for (OWLEntity curObj : collector.getObjects()) {
                if (this.objectsExpandedWithDefiningAxioms.contains(curObj)) continue;
                added = this.expandWithDefiningAxioms(curObj, remainingSpace);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * this.expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithDefiningAxioms.add(curObj);
            }
            this.expandedWithDefiningAxioms.add(ax);
        }
        if (axiomsAdded > 0) {
            return axiomsAdded;
        }
        for (OWLAxiom ax : new HashSet<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithReferencingAxioms.contains(ax)) continue;
            collector = new OWLEntityCollector();
            ax.accept(collector);
            for (OWLEntity curObj : collector.getObjects()) {
                if (this.objectsExpandedWithReferencingAxioms.contains(curObj)) continue;
                added = this.expandWithReferencingAxioms(curObj, this.expansionLimit);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * this.expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithReferencingAxioms.add(curObj);
            }
            this.expandedWithReferencingAxioms.add(ax);
        }
        return axiomsAdded;
    }

    private int expandWithDefiningAxioms(OWLEntity obj, int limit) throws OWLException {
        HashSet<OWLLogicalAxiom> expansionAxioms = new HashSet<OWLLogicalAxiom>();
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.getOWLOntology())) {
            if (obj instanceof OWLClass) {
                expansionAxioms.addAll(ont.getAxioms((OWLClass)obj));
                continue;
            }
            if (obj instanceof OWLObjectProperty) {
                expansionAxioms.addAll(ont.getAxioms((OWLObjectProperty)obj));
                continue;
            }
            if (obj instanceof OWLDataProperty) {
                expansionAxioms.addAll(ont.getAxioms((OWLDataProperty)obj));
                continue;
            }
            if (!(obj instanceof OWLIndividual)) continue;
            expansionAxioms.addAll(ont.getAxioms((OWLIndividual)obj));
        }
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxOWLDebugger.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private int expandWithReferencingAxioms(OWLEntity obj, int limit) throws OWLException {
        HashSet<OWLAxiom> expansionAxioms = new HashSet<OWLAxiom>();
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.getOWLOntology())) {
            expansionAxioms.addAll(ont.getReferencingAxioms(obj));
        }
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxOWLDebugger.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private static <N extends OWLAxiom> int addMax(Set<N> source, Set<N> dest, int limit) {
        int count = 0;
        for (OWLAxiom obj : source) {
            if (count == limit) break;
            if (obj instanceof OWLAnnotationAxiom || !dest.add(obj)) continue;
            ++count;
        }
        return count;
    }

    private void performFastPruning() throws OWLException {
        logger.setLevel(Level.INFO);
        HashSet<OWLAxiom> axiomWindow = new HashSet<OWLAxiom>();
        Object[] axioms = this.debuggingAxioms.toArray();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Fast pruning: ");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("     - Window size: " + this.fastPruningWindowSize);
        }
        int windowCount = this.debuggingAxioms.size() / this.fastPruningWindowSize;
        for (int currentWindow = 0; currentWindow < windowCount; ++currentWindow) {
            axiomWindow.clear();
            int startIndex = currentWindow * this.fastPruningWindowSize;
            int endIndex = startIndex + this.fastPruningWindowSize;
            for (int axiomIndex = startIndex; axiomIndex < endIndex; ++axiomIndex) {
                OWLAxiom currentAxiom = (OWLAxiom)axioms[axiomIndex];
                axiomWindow.add(currentAxiom);
                this.debuggingAxioms.remove(currentAxiom);
            }
            if (!this.isSatisfiable()) continue;
            this.debuggingAxioms.addAll(axiomWindow);
        }
        axiomWindow.clear();
        int remainingAxiomsCount = this.debuggingAxioms.size() % this.fastPruningWindowSize;
        if (remainingAxiomsCount > 0) {
            for (int fragmentIndex = windowCount * this.fastPruningWindowSize; fragmentIndex < axioms.length; ++fragmentIndex) {
                OWLAxiom curAxiom = (OWLAxiom)axioms[fragmentIndex];
                axiomWindow.add(curAxiom);
                this.debuggingAxioms.remove(curAxiom);
            }
            if (this.isSatisfiable()) {
                this.debuggingAxioms.addAll(axiomWindow);
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("    - End of fast pruning");
        }
    }

    private void performSlowPruning() throws OWLException {
        HashSet<OWLAxiom> axiomsCopy = new HashSet<OWLAxiom>(this.debuggingAxioms);
        for (OWLAxiom ax : axiomsCopy) {
            this.debuggingAxioms.remove(ax);
            if (!this.isSatisfiable()) continue;
            this.debuggingAxioms.add(ax);
        }
    }

    private boolean isSatisfiable() throws OWLException {
        this.createDebuggingOntology();
        ++this.ontologyCounter;
        this.reasoner.clearOntologies();
        this.reasoner.loadOntologies(Collections.singleton(this.debuggingOntology));
        ++this.satTestCount;
        this.reasoner.classify();
        return this.reasoner.isSatisfiable(this.currentClass);
    }

    private void createDebuggingOntology() throws OWLException {
        OWLAxiom ax2;
        if (this.debuggingOntology != null) {
            this.owlOntologyManager.removeOntology(this.debuggingOntology.getURI());
        }
        URI uri = BlackBoxOWLDebugger.createURI();
        SimpleURIMapper mapper = new SimpleURIMapper(uri, uri);
        this.owlOntologyManager.addURIMapper(mapper);
        this.debuggingOntology = this.owlOntologyManager.createOntology(uri);
        this.owlOntologyManager.removeURIMapper(mapper);
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLAxiom ax2 : this.debuggingAxioms) {
            changes.add(new AddAxiom(this.debuggingOntology, ax2));
        }
        for (OWLAxiom ax2 : this.temporaryAxioms) {
            changes.add(new AddAxiom(this.debuggingOntology, ax2));
        }
        OWLDataFactory factory = this.owlOntologyManager.getOWLDataFactory();
        ax2 = factory.getOWLSubClassAxiom(this.currentClass, factory.getOWLThing());
        changes.add(new AddAxiom(this.debuggingOntology, ax2));
        this.owlOntologyManager.applyChanges(changes);
    }

    private void resetSatisfiabilityTestCounter() {
        this.satTestCount = 0;
    }

    private void generateSOSAxioms() throws OWLException {
        this.resetSatisfiabilityTestCounter();
        this.expandWithDefiningAxioms(this.currentClass, this.expansionLimit);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Initial axiom count: " + this.debuggingAxioms.size());
        }
        int totalAdded = 0;
        int expansionCount = 0;
        while (this.isSatisfiable()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Expanding axioms (expansion " + expansionCount + ")");
            }
            ++expansionCount;
            int numberAdded = this.expandAxioms();
            totalAdded += numberAdded;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("    ... expanded by " + numberAdded);
            }
            if (numberAdded != 0) continue;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("ERROR! Cannot find SOS axioms!");
            }
            this.debuggingAxioms.clear();
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Total number of axioms added: " + totalAdded);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("FOUND CLASH! Prunning " + this.debuggingAxioms.size() + " axioms...");
        }
        this.resetSatisfiabilityTestCounter();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Fast pruning...");
        }
        if (this.performRepeatedFastPruning) {
            this.fastPruningWindowSize = this.debuggingAxioms.size() / 10;
            if (this.fastPruningWindowSize < 10) {
                this.fastPruningWindowSize = 10;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("    Initial fast prunung window size: " + this.fastPruningWindowSize);
            }
            int fastPruningCounter = 0;
            while (this.fastPruningWindowSize != 1) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("    Round: " + fastPruningCounter + " (axioms to prune: " + this.debuggingAxioms.size() + ")");
                }
                ++fastPruningCounter;
                this.performFastPruning();
                this.fastPruningWindowSize /= 3;
                if (this.fastPruningWindowSize >= 1) continue;
                this.fastPruningWindowSize = 1;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("... end of fast pruning. Axioms remaining: " + this.debuggingAxioms.size());
                logger.info("Performed " + this.satTestCount + " satisfiability tests during fast pruning");
            }
        } else {
            this.fastPruningWindowSize = 10;
            this.performFastPruning();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("... end of fast pruning. Axioms remaining: " + this.debuggingAxioms.size());
                logger.info("Performed " + this.satTestCount + " satisfiability tests during fast pruning");
            }
        }
        int totalSatTests = this.satTestCount;
        this.resetSatisfiabilityTestCounter();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Slow pruning...");
        }
        this.performSlowPruning();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("... end of slow pruning");
            logger.info("Performed " + this.satTestCount + " satisfiability tests during slow pruning");
        }
        totalSatTests += this.satTestCount;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Total number of satisfiability tests performed: " + totalSatTests);
        }
    }

    private static URI createURI() {
        return URI.create("http://debugging.blackbox#" + System.nanoTime());
    }
}

