/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.debugging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owl.util.OWLEntityCollector;

public class JustificationMap {
    private Set<OWLAxiom> axioms;
    private Set<OWLAxiom> rootAxioms;
    private Set<OWLAxiom> usedAxioms;
    private Map<OWLAxiom, Set<OWLAxiom>> map;
    private Map<OWLEntity, Set<OWLAxiom>> axiomsByRHS;
    private Map<OWLEntity, Set<OWLAxiom>> axiomsByLHS;
    private OWLDescription desc;

    public JustificationMap(OWLDescription desc, Set<OWLAxiom> axioms) {
        this.axioms = axioms;
        this.desc = desc;
        this.rootAxioms = new HashSet<OWLAxiom>();
        this.map = new HashMap<OWLAxiom, Set<OWLAxiom>>();
        this.usedAxioms = new HashSet<OWLAxiom>();
        this.axiomsByRHS = new HashMap<OWLEntity, Set<OWLAxiom>>();
        this.axiomsByLHS = new HashMap<OWLEntity, Set<OWLAxiom>>();
        this.createMap();
    }

    private void createMap() {
        for (OWLAxiom ax : this.axioms) {
            OWLAxiomPartExtractor extractor = new OWLAxiomPartExtractor();
            ax.accept(extractor);
            OWLEntityCollector rhsCollector = new OWLEntityCollector();
            for (OWLObject rhsObject : extractor.getRHS()) {
                rhsObject.accept(rhsCollector);
            }
            for (OWLEntity rhsEntity : rhsCollector.getObjects()) {
                JustificationMap.index(rhsEntity, this.axiomsByRHS, ax);
            }
            OWLEntityCollector lhsCollector = new OWLEntityCollector();
            for (OWLObject lhsObject : extractor.getLHS()) {
                lhsObject.accept(lhsCollector);
            }
            for (OWLEntity lhsEntity : lhsCollector.getObjects()) {
                JustificationMap.index(lhsEntity, this.axiomsByLHS, ax);
            }
        }
        this.buildChildren(this.desc);
    }

    private Set<OWLAxiom> getAxiomsByLHS(OWLEntity lhs) {
        Set<OWLAxiom> axioms = this.axiomsByLHS.get(lhs);
        if (axioms != null) {
            TreeSet<OWLAxiom> ts = new TreeSet<OWLAxiom>(new OWLAxiomComparator());
            ts.addAll(axioms);
            return ts;
        }
        return Collections.emptySet();
    }

    private Set<OWLAxiom> getAxiomsByRHS(OWLEntity rhs) {
        Set<OWLAxiom> axioms = this.axiomsByRHS.get(rhs);
        if (axioms != null) {
            return axioms;
        }
        return Collections.emptySet();
    }

    private void buildChildren(OWLDescription seed) {
        OWLEntityCollector collector = new OWLEntityCollector();
        seed.accept(collector);
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLEntity ent : collector.getObjects()) {
            Set<OWLAxiom> axs = this.getAxiomsByLHS(ent);
            for (OWLAxiom ax : axs) {
                result.add(ax);
                this.usedAxioms.add(ax);
            }
        }
        this.rootAxioms.addAll(result);
        this.buildChildren(result);
    }

    private void buildChildren(Set<OWLAxiom> axioms) {
        ArrayList<Set<OWLAxiom>> axiomChildren = new ArrayList<Set<OWLAxiom>>();
        for (OWLAxiom oWLAxiom : axioms) {
            Set<OWLAxiom> children = this.build(oWLAxiom);
            for (OWLAxiom childAx : children) {
                JustificationMap.index(oWLAxiom, this.map, childAx);
            }
            axiomChildren.add(children);
        }
        for (Set set : axiomChildren) {
            this.buildChildren(set);
        }
    }

    private Set<OWLAxiom> build(OWLAxiom parentAxiom) {
        this.usedAxioms.add(parentAxiom);
        OWLAxiomPartExtractor extractor = new OWLAxiomPartExtractor();
        parentAxiom.accept(extractor);
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLObject obj : extractor.getRHS()) {
            OWLEntityCollector collector = new OWLEntityCollector();
            obj.accept(collector);
            for (OWLEntity ent : collector.getObjects()) {
                Set<OWLAxiom> axs = this.getAxiomsByLHS(ent);
                for (OWLAxiom ax : axs) {
                    if (this.usedAxioms.contains(ax)) continue;
                    result.add(ax);
                    this.usedAxioms.add(ax);
                }
            }
        }
        return result;
    }

    private static <K, V> void index(K key, Map<K, Set<V>> map, V value) {
        Set<V> values = map.get(key);
        if (values == null) {
            values = new HashSet<V>();
            map.put(key, values);
        }
        values.add(value);
    }

    public Set<OWLAxiom> getRootAxioms() {
        return this.rootAxioms;
    }

    public Set<OWLAxiom> getChildAxioms(OWLAxiom ax) {
        Set<OWLAxiom> result = this.map.get(ax);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    private class OWLAxiomComparator
    extends OWLAxiomVisitorAdapter
    implements Comparator<OWLAxiom> {
        private int result;

        private OWLAxiomComparator() {
        }

        @Override
        public void visit(OWLSubClassAxiom axiom) {
            this.result = 0;
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.result = 1;
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            this.result = 2;
        }

        @Override
        public int compare(OWLAxiom o1, OWLAxiom o2) {
            this.result = 0;
            o1.accept(this);
            int result1 = this.result;
            o2.accept(this);
            int result2 = this.result;
            int diff = result2 - result1;
            if (diff != 0) {
                return diff;
            }
            return -1;
        }
    }

    private class OWLAxiomPartExtractor
    extends OWLAxiomVisitorAdapter {
        private Set<OWLObject> rhs = new HashSet<OWLObject>();
        private Set<OWLObject> lhs = new HashSet<OWLObject>();

        public Set<OWLObject> getRHS() {
            return this.rhs;
        }

        public Set<OWLObject> getLHS() {
            return this.lhs;
        }

        @Override
        public void visit(OWLSubClassAxiom axiom) {
            this.rhs.add(axiom.getSuperClass());
            this.lhs.add(axiom.getSubClass());
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getObject());
            this.rhs.add((OWLObject)axiom.getProperty());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            this.rhs.addAll(axiom.getDescriptions());
            this.lhs.addAll(axiom.getDescriptions());
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            this.rhs.add(axiom.getDomain());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.rhs.add(axiom.getDomain());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.rhs.add((OWLObject)axiom.getObject());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            this.rhs.addAll(axiom.getIndividuals());
            this.lhs.addAll(axiom.getIndividuals());
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getRange());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.rhs.add((OWLObject)axiom.getObject());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLObjectSubPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
            this.lhs.add((OWLObject)axiom.getSubProperty());
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            this.rhs.addAll(axiom.getDescriptions());
            this.rhs.add(axiom.getOWLClass());
            this.lhs.add(axiom.getOWLClass());
            this.lhs.addAll(axiom.getDescriptions());
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getRange());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            this.rhs.add(axiom.getDescription());
            this.lhs.add(axiom.getIndividual());
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.rhs.addAll(axiom.getDescriptions());
            this.lhs.addAll(axiom.getDescriptions());
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLDataSubPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLSameIndividualsAxiom axiom) {
            this.rhs.addAll(axiom.getIndividuals());
            this.lhs.addAll(axiom.getIndividuals());
        }

        @Override
        public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            this.rhs.add(axiom.getSuperProperty());
            this.lhs.addAll(axiom.getPropertyChain());
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.rhs.addAll(axiom.getProperties());
            this.lhs.addAll(axiom.getProperties());
        }

        @Override
        public void visit(SWRLRule rule) {
        }
    }
}

