/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owl.io.OWLParserFactory;

public class OWLParserFactoryRegistry {
    private static OWLParserFactoryRegistry instance;
    private List<OWLParserFactory> parserFactories = new ArrayList<OWLParserFactory>();

    private OWLParserFactoryRegistry() {
    }

    public static synchronized OWLParserFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new OWLParserFactoryRegistry();
        }
        return instance;
    }

    public void clearParserFactories() {
        this.parserFactories.clear();
    }

    public List<OWLParserFactory> getParserFactories() {
        return Collections.unmodifiableList(this.parserFactories);
    }

    public void registerParserFactory(OWLParserFactory parserFactory) {
        this.parserFactories.add(0, parserFactory);
    }

    public void unregisterParserFactory(OWLParserFactory parserFactory) {
        this.parserFactories.remove(parserFactory);
    }
}

