/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.model.OWLRuntimeException;

public class ReaderInputSource
implements OWLOntologyInputSource {
    private URI physicalURI;
    private String buffer;

    public ReaderInputSource(Reader reader) {
        this(reader, URI.create("http://org.semanticweb.ontologies/Ontology" + System.nanoTime()));
    }

    public ReaderInputSource(Reader reader, URI physicalURI) {
        this.physicalURI = physicalURI;
        this.fillBuffer(reader);
    }

    private void fillBuffer(Reader reader) {
        try {
            int read;
            StringBuilder builder = new StringBuilder();
            char[] tempBuffer = new char[4096];
            while ((read = reader.read(tempBuffer)) != -1) {
                builder.append(tempBuffer, 0, read);
            }
            this.buffer = builder.toString();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public URI getPhysicalURI() {
        return this.physicalURI;
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.buffer);
    }

    @Override
    public boolean isReaderAvailable() {
        return true;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return false;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }
}

