/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLOntologyInputSourceException;

public class StreamInputSource
implements OWLOntologyInputSource {
    private URI physicalURI;
    private byte[] buffer;

    public StreamInputSource(InputStream is) {
        this(is, URI.create("http://org.semanticweb.ontologies/Ontology" + System.nanoTime()));
    }

    public StreamInputSource(InputStream stream, URI physicalURI) {
        this.physicalURI = physicalURI;
        this.readIntoBuffer(stream);
    }

    private void readIntoBuffer(InputStream stream) {
        try {
            int read;
            byte[] tempBuffer = new byte[4096];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((read = stream.read(tempBuffer)) != -1) {
                bos.write(tempBuffer, 0, read);
            }
            this.buffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public boolean isInputStreamAvailable() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buffer);
    }

    @Override
    public URI getPhysicalURI() {
        return this.physicalURI;
    }

    @Override
    public Reader getReader() {
        return null;
    }

    @Override
    public boolean isReaderAvailable() {
        return false;
    }
}

