/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.metrics;

import java.util.HashSet;
import java.util.List;
import org.semanticweb.owl.metrics.IntegerValuedMetric;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class HiddenGCICount
extends IntegerValuedMetric {
    public HiddenGCICount(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    @Override
    protected void disposeMetric() {
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLEquivalentClassesAxiom) && !(oWLOntologyChange.getAxiom() instanceof OWLSubClassAxiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Integer recomputeMetric() {
        HashSet<OWLClass> processed = new HashSet<OWLClass>();
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        for (OWLOntology ont : this.getOntologies()) {
            block1: for (OWLClass cls : ont.getReferencedClasses()) {
                if (processed.contains(cls)) continue;
                processed.add(cls);
                boolean foundEquivalentClassesAxiom = false;
                boolean foundSubClassAxiom = false;
                for (OWLOntology o : this.getOntologies()) {
                    if (!foundEquivalentClassesAxiom) {
                        boolean bl = foundEquivalentClassesAxiom = !o.getEquivalentClassesAxioms(cls).isEmpty();
                    }
                    if (!foundSubClassAxiom) {
                        boolean bl = foundSubClassAxiom = !o.getSubClassAxiomsForLHS(cls).isEmpty();
                    }
                    if (!foundSubClassAxiom || !foundEquivalentClassesAxiom) continue;
                    result.add(cls);
                    continue block1;
                }
            }
        }
        return result.size();
    }

    @Override
    public String getName() {
        return "Hidden GCI Count";
    }
}

