/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.normalform;

import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.normalform.NormalFormRewriter;
import org.semanticweb.owl.normalform.OWLObjectComplementOfExtractor;
import org.semanticweb.owl.util.NNF;

public class NegationalNormalFormConverter
implements NormalFormRewriter {
    private NNF nnf;
    private OWLObjectComplementOfExtractor extractor;

    public NegationalNormalFormConverter(OWLDataFactory dataFactory) {
        this.nnf = new NNF(dataFactory);
        this.extractor = new OWLObjectComplementOfExtractor();
    }

    @Override
    public boolean isInNormalForm(OWLDescription description) {
        this.extractor.getComplementedDescriptions(description);
        for (OWLDescription desc : this.extractor.getComplementedDescriptions(description)) {
            if (!desc.isAnonymous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OWLDescription convertToNormalForm(OWLDescription description) {
        this.nnf.reset();
        return description.accept(this.nnf);
    }
}

