/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.profiles;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDataVisitorEx;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitorEx;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.profiles.AxiomNotAllowed;
import org.semanticweb.owl.profiles.ConstructNotAllowed;
import org.semanticweb.owl.profiles.DataRangeNotAllowed;
import org.semanticweb.owl.profiles.DescriptionNotAllowed;
import org.semanticweb.owl.profiles.OWLProfile;
import org.semanticweb.owl.profiles.OWLProfileReport;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class RLProfile
implements OWLProfile {
    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology, OWLOntologyManager manager) {
        RLAxiomChecker checker = new RLAxiomChecker();
        HashSet<ConstructNotAllowed> disallowedConstructs = new HashSet<ConstructNotAllowed>();
        for (OWLLogicalAxiom ax : ontology.getLogicalAxioms()) {
            AxiomNotAllowed<? extends OWLAxiom> cause = ax.accept(checker);
            if (cause == null) continue;
            disallowedConstructs.add(cause);
        }
        return new OWLProfileReport(this, ontology.getURI(), disallowedConstructs);
    }

    @Override
    public String getName() {
        return "RL";
    }

    private class RLEquivClassChecker
    implements OWLDescriptionVisitorEx<DescriptionNotAllowed> {
        private final RLDataChecker dataChecker;

        public RLEquivClassChecker(RLDataChecker dataChecker) {
            this.dataChecker = dataChecker;
        }

        @Override
        public DescriptionNotAllowed visit(OWLClass desc) {
            if (desc.isOWLThing()) {
                return new DescriptionNotAllowed(desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataAllRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataExactCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataMaxCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataMinCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataSomeRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataValueRestriction desc) {
            DataRangeNotAllowed cause = ((OWLConstant)desc.getValue()).accept(this.dataChecker);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectAllRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectComplementOf desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectExactCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription d : desc.getOperands()) {
                DescriptionNotAllowed cause = d.accept(this);
                if (cause == null) continue;
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectMaxCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectMinCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectOneOf desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectSelfRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectSomeRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectUnionOf desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectValueRestriction desc) {
            return null;
        }
    }

    private class RLSuperClassChecker
    implements OWLDescriptionVisitorEx<DescriptionNotAllowed> {
        private final RLSubClassChecker subChecker;
        private final RLDataChecker dataChecker;

        public RLSuperClassChecker(RLDataChecker dataChecker, RLSubClassChecker subChecker) {
            this.dataChecker = dataChecker;
            this.subChecker = subChecker;
        }

        @Override
        public DescriptionNotAllowed visit(OWLClass desc) {
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataAllRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataExactCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataMaxCardinalityRestriction desc) {
            switch (desc.getCardinality()) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    return new DescriptionNotAllowed(desc);
                }
            }
            DataRangeNotAllowed cause = ((OWLDataRange)desc.getFiller()).accept(this.dataChecker);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataMinCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataSomeRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataValueRestriction desc) {
            DataRangeNotAllowed cause = ((OWLConstant)desc.getValue()).accept(this.dataChecker);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectAllRestriction desc) {
            DescriptionNotAllowed cause = ((OWLDescription)desc.getFiller()).accept(this);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectComplementOf desc) {
            DescriptionNotAllowed cause = desc.getOperand().accept(this.subChecker);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectExactCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription d : desc.getOperands()) {
                DescriptionNotAllowed cause = d.accept(this);
                if (cause == null) continue;
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectMaxCardinalityRestriction desc) {
            switch (desc.getCardinality()) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    return new DescriptionNotAllowed(desc);
                }
            }
            DescriptionNotAllowed cause = ((OWLDescription)desc.getFiller()).accept(this.subChecker);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectMinCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectOneOf desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectSelfRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectSomeRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectUnionOf desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectValueRestriction desc) {
            return null;
        }
    }

    private class RLSubClassChecker
    implements OWLDescriptionVisitorEx<DescriptionNotAllowed> {
        private final RLDataChecker dataChecker;

        public RLSubClassChecker(RLDataChecker dataChecker) {
            this.dataChecker = dataChecker;
        }

        @Override
        public DescriptionNotAllowed visit(OWLClass desc) {
            if (desc.isOWLThing()) {
                return new DescriptionNotAllowed(desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataAllRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataExactCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataMaxCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataMinCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataSomeRestriction desc) {
            DataRangeNotAllowed cause = ((OWLDataRange)desc.getFiller()).accept(this.dataChecker);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLDataValueRestriction desc) {
            DataRangeNotAllowed cause = ((OWLConstant)desc.getValue()).accept(this.dataChecker);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectAllRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectComplementOf desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectExactCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription d : desc.getOperands()) {
                DescriptionNotAllowed cause = d.accept(this);
                if (cause == null) continue;
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectMaxCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectMinCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectOneOf desc) {
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectSelfRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectSomeRestriction desc) {
            DescriptionNotAllowed cause = ((OWLDescription)desc.getFiller()).accept(this);
            if (cause != null) {
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectUnionOf desc) {
            for (OWLDescription d : desc.getOperands()) {
                DescriptionNotAllowed cause = d.accept(this);
                if (cause == null) continue;
                return new DescriptionNotAllowed((ConstructNotAllowed)cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public DescriptionNotAllowed visit(OWLObjectValueRestriction desc) {
            return null;
        }
    }

    private static class RLDataChecker
    implements OWLDataVisitorEx<DataRangeNotAllowed> {
        private static final Set<URI> allowedDatatypes;

        private RLDataChecker() {
        }

        @Override
        public DataRangeNotAllowed visit(OWLDataComplementOf node) {
            return new DataRangeNotAllowed(node);
        }

        @Override
        public DataRangeNotAllowed visit(OWLDataOneOf node) {
            return new DataRangeNotAllowed(node);
        }

        @Override
        public DataRangeNotAllowed visit(OWLDataRangeFacetRestriction node) {
            throw new IllegalStateException();
        }

        @Override
        public DataRangeNotAllowed visit(OWLDataRangeRestriction node) {
            return new DataRangeNotAllowed(node);
        }

        @Override
        public DataRangeNotAllowed visit(OWLDataType node) {
            return allowedDatatypes.contains(node.getURI()) ? null : new DataRangeNotAllowed(node);
        }

        @Override
        public DataRangeNotAllowed visit(OWLTypedConstant node) {
            return node.getDataType().accept(this);
        }

        @Override
        public DataRangeNotAllowed visit(OWLUntypedConstant node) {
            return null;
        }

        static {
            HashSet<URI> s = new HashSet<URI>();
            s.add(OWLRDFVocabulary.RDF_XML_LITERAL.getURI());
            s.add(OWLRDFVocabulary.RDFS_LITERAL.getURI());
            s.add(XSDVocabulary.DECIMAL.getURI());
            s.add(XSDVocabulary.INTEGER.getURI());
            s.add(XSDVocabulary.NON_NEGATIVE_INTEGER.getURI());
            s.add(XSDVocabulary.NON_POSITIVE_INTEGER.getURI());
            s.add(XSDVocabulary.POSITIVE_INTEGER.getURI());
            s.add(XSDVocabulary.NEGATIVE_INTEGER.getURI());
            s.add(XSDVocabulary.LONG.getURI());
            s.add(XSDVocabulary.INT.getURI());
            s.add(XSDVocabulary.SHORT.getURI());
            s.add(XSDVocabulary.BYTE.getURI());
            s.add(XSDVocabulary.UNSIGNED_LONG.getURI());
            s.add(XSDVocabulary.UNSIGNED_INT.getURI());
            s.add(XSDVocabulary.UNSIGNED_SHORT.getURI());
            s.add(XSDVocabulary.UNSIGNED_BYTE.getURI());
            s.add(XSDVocabulary.FLOAT.getURI());
            s.add(XSDVocabulary.DOUBLE.getURI());
            s.add(XSDVocabulary.STRING.getURI());
            s.add(XSDVocabulary.NORMALIZED_STRING.getURI());
            s.add(XSDVocabulary.TOKEN.getURI());
            s.add(XSDVocabulary.LANGUAGE.getURI());
            s.add(XSDVocabulary.NAME.getURI());
            s.add(XSDVocabulary.NCNAME.getURI());
            s.add(XSDVocabulary.NMTOKEN.getURI());
            s.add(XSDVocabulary.BOOLEAN.getURI());
            s.add(XSDVocabulary.HEX_BINARY.getURI());
            s.add(XSDVocabulary.BASE_64_BINARY.getURI());
            s.add(XSDVocabulary.ANY_URI.getURI());
            s.add(XSDVocabulary.DATE_TIME.getURI());
            s.add(XSDVocabulary.DATE_TIME_STAMP.getURI());
            allowedDatatypes = Collections.unmodifiableSet(s);
        }
    }

    private class RLAxiomChecker
    implements OWLAxiomVisitorEx<AxiomNotAllowed<? extends OWLAxiom>> {
        private final RLDataChecker dataChecker = new RLDataChecker();
        private final RLSubClassChecker subChecker;
        private final RLSuperClassChecker superChecker;
        private final RLEquivClassChecker equivChecker;

        public RLAxiomChecker() {
            this.subChecker = new RLSubClassChecker(this.dataChecker);
            this.superChecker = new RLSuperClassChecker(this.dataChecker, this.subChecker);
            this.equivChecker = new RLEquivClassChecker(this.dataChecker);
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLAxiomAnnotationAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLClassAssertionAxiom axiom) {
            DescriptionNotAllowed cause = axiom.getDescription().accept(this.superChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLClassAssertionAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDataPropertyAssertionAxiom axiom) {
            DataRangeNotAllowed cause = ((OWLConstant)axiom.getObject()).accept(this.dataChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLDataPropertyAssertionAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDataPropertyDomainAxiom axiom) {
            DescriptionNotAllowed cause = axiom.getDomain().accept(this.superChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLDataPropertyDomainAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDataPropertyRangeAxiom axiom) {
            DataRangeNotAllowed cause = ((OWLDataRange)axiom.getRange()).accept(this.dataChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLDataPropertyRangeAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDataSubPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDeclarationAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDifferentIndividualsAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDisjointClassesAxiom axiom) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                DescriptionNotAllowed cause = desc.accept(this.subChecker);
                if (cause == null) continue;
                return new AxiomNotAllowed<OWLDisjointClassesAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDisjointDataPropertiesAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDisjointObjectPropertiesAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLDisjointUnionAxiom axiom) {
            return new AxiomNotAllowed<OWLDisjointUnionAxiom>(axiom);
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLEntityAnnotationAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                DescriptionNotAllowed cause = desc.accept(this.equivChecker);
                if (cause == null) continue;
                return new AxiomNotAllowed<OWLEquivalentClassesAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLFunctionalDataPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLImportsDeclaration axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLInverseObjectPropertiesAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            DataRangeNotAllowed cause = ((OWLConstant)axiom.getObject()).accept(this.dataChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLNegativeDataPropertyAssertionAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLObjectPropertyAssertionAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLObjectPropertyDomainAxiom axiom) {
            DescriptionNotAllowed cause = axiom.getDomain().accept(this.superChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLObjectPropertyDomainAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLObjectPropertyRangeAxiom axiom) {
            DescriptionNotAllowed cause = ((OWLDescription)axiom.getRange()).accept(this.superChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLObjectPropertyRangeAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLObjectSubPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLOntologyAnnotationAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLSameIndividualsAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLSubClassAxiom axiom) {
            DescriptionNotAllowed cause = axiom.getSubClass().accept(this.subChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLSubClassAxiom>((ConstructNotAllowed)cause, axiom);
            }
            cause = axiom.getSuperClass().accept(this.superChecker);
            if (cause != null) {
                return new AxiomNotAllowed<OWLSubClassAxiom>((ConstructNotAllowed)cause, axiom);
            }
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return null;
        }

        @Override
        public AxiomNotAllowed<? extends OWLAxiom> visit(SWRLRule rule) {
            return new AxiomNotAllowed<SWRLRule>(rule);
        }
    }
}

