/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologySetProvider;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.util.OWLObjectVisitorAdapter;
import org.semanticweb.owl.util.ShortFormProvider;
import org.semanticweb.owl.util.SimpleShortFormProvider;

public class AnnotationValueShortFormProvider
implements ShortFormProvider {
    private OWLOntologySetProvider ontologySetProvider;
    private ShortFormProvider alternateShortFormProvider;
    private List<URI> annotationURIs;
    private Map<URI, List<String>> preferredLanguageMap;

    public AnnotationValueShortFormProvider(List<URI> annotationURIs, Map<URI, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider) {
        this(annotationURIs, preferredLanguageMap, ontologySetProvider, new SimpleShortFormProvider());
    }

    public AnnotationValueShortFormProvider(List<URI> annotationURIs, Map<URI, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider, ShortFormProvider alternateShortFormProvider) {
        this.annotationURIs = annotationURIs;
        this.preferredLanguageMap = preferredLanguageMap;
        this.ontologySetProvider = ontologySetProvider;
        this.alternateShortFormProvider = alternateShortFormProvider;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        for (URI annotationURI : this.annotationURIs) {
            AnnotationLanguageFilter checker = new AnnotationLanguageFilter(annotationURI, this.preferredLanguageMap.get(annotationURI));
            for (OWLOntology ontology : this.ontologySetProvider.getOntologies()) {
                for (OWLAnnotation anno : entity.getAnnotations(ontology, annotationURI)) {
                    anno.accept(checker);
                }
            }
            if (checker.getMatch() == null) continue;
            return this.getRendering(checker.getMatch());
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    private String getRendering(OWLObject object) {
        if (object instanceof OWLConstant) {
            return ((OWLConstant)object).getLiteral();
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    public List<URI> getAnnotationURIs() {
        return this.annotationURIs;
    }

    public Map<URI, List<String>> getPreferredLanguageMap() {
        return this.preferredLanguageMap;
    }

    @Override
    public void dispose() {
    }

    private class AnnotationLanguageFilter
    extends OWLObjectVisitorAdapter {
        private URI uri;
        private List<String> preferredLanguages;
        OWLObject candidateValue = null;
        int lastLangMatchIndex = Integer.MAX_VALUE;

        private AnnotationLanguageFilter(URI uri, List<String> preferredLanguages) {
            this.uri = uri;
            this.preferredLanguages = preferredLanguages;
        }

        public OWLObject getMatch() {
            return this.candidateValue;
        }

        @Override
        public void visit(OWLConstantAnnotation anno) {
            if (this.lastLangMatchIndex > 0 && anno.getAnnotationURI().equals(this.uri)) {
                ((OWLConstant)anno.getAnnotationValue()).accept(this);
            }
        }

        @Override
        public void visit(OWLUntypedConstant untypedConstantVal) {
            if (this.preferredLanguages == null || this.preferredLanguages.isEmpty()) {
                this.lastLangMatchIndex = 0;
                this.candidateValue = untypedConstantVal;
            } else {
                int index = this.preferredLanguages.indexOf(untypedConstantVal.getLang());
                if (index >= 0 && index < this.lastLangMatchIndex) {
                    this.lastLangMatchIndex = index;
                    this.candidateValue = untypedConstantVal;
                }
            }
        }

        @Override
        public void visit(OWLTypedConstant node) {
            if (this.preferredLanguages == null || this.preferredLanguages.isEmpty()) {
                this.lastLangMatchIndex = 0;
                this.candidateValue = node;
            } else {
                int index = this.preferredLanguages.indexOf(null);
                if (index >= 0 && index < this.lastLangMatchIndex) {
                    this.lastLangMatchIndex = index;
                    this.candidateValue = node;
                }
            }
        }
    }
}

