/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.vocab.Namespaces;
import org.semanticweb.owl.vocab.OWLXMLVocabulary;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutoURIMapper
extends DefaultHandler
implements OWLOntologyURIMapper {
    private Set<String> fileExtensions;
    private File directory;
    private boolean mapped;
    private boolean recursive;
    private Map<String, OntologyRootElementHandler> handlerMap;
    private File currentFile;
    private Map<URI, URI> uriMap;
    private Map<String, URI> oboFileMap;
    private SAXParserFactory parserFactory;

    public AutoURIMapper(File rootDirectory, boolean recursive) {
        this.directory = rootDirectory;
        this.recursive = recursive;
        this.uriMap = new HashMap<URI, URI>();
        this.oboFileMap = new HashMap<String, URI>();
        this.fileExtensions = new HashSet<String>();
        this.fileExtensions.add("owl");
        this.fileExtensions.add("xml");
        this.fileExtensions.add("rdf");
        this.mapped = false;
        this.handlerMap = new HashMap<String, OntologyRootElementHandler>();
        this.handlerMap.put((Object)((Object)Namespaces.RDF) + "RDF", new RDFXMLOntologyRootElementHandler());
        this.handlerMap.put(OWLXMLVocabulary.ONTOLOGY.toString(), new OWLXMLOntologyRootElementHandler());
        this.parserFactory = SAXParserFactory.newInstance();
        this.parserFactory.setNamespaceAware(true);
    }

    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(Set<String> extensions) {
        this.fileExtensions.clear();
        this.fileExtensions.addAll(extensions);
    }

    public Set<URI> getOntologyURIs() {
        if (!this.mapped) {
            this.mapFiles();
        }
        return new HashSet<URI>(this.uriMap.keySet());
    }

    public void update() {
        this.mapFiles();
    }

    @Override
    public URI getPhysicalURI(URI ontologyURI) {
        int lastSepIndex;
        String name;
        URI physicalURI;
        String path;
        if (!this.mapped) {
            this.mapFiles();
        }
        if (ontologyURI.toString().endsWith(".obo") && (path = ontologyURI.getPath()) != null && (physicalURI = this.oboFileMap.get(name = path.substring((lastSepIndex = path.lastIndexOf(47)) + 1, path.length()))) != null) {
            return physicalURI;
        }
        return this.uriMap.get(ontologyURI);
    }

    private void mapFiles() {
        this.mapped = true;
        this.uriMap.clear();
        this.processFile(this.directory);
    }

    private void processFile(File f) {
        if (f.isHidden()) {
            return;
        }
        for (File file : f.listFiles()) {
            if (file.isDirectory() && this.recursive) {
                this.processFile(file);
                continue;
            }
            boolean parsedFile = false;
            if (file.getName().endsWith(".obo")) {
                this.oboFileMap.put(file.getName(), file.toURI());
                continue;
            }
            for (String ext : this.fileExtensions) {
                if (!file.getName().endsWith(ext)) continue;
                this.parseFile(file);
                parsedFile = true;
            }
        }
    }

    private void parseFile(File file) {
        try {
            this.currentFile = file;
            SAXParser parser = this.parserFactory.newSAXParser();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            parser.parse((InputStream)is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new OWLRuntimeException(e);
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        OntologyRootElementHandler handler = this.handlerMap.get(uri + localName);
        if (handler != null) {
            URI ontologyURI = handler.handle(attributes);
            if (ontologyURI != null) {
                this.uriMap.put(ontologyURI, this.currentFile.toURI());
            }
            throw new SAXException();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoURIMapper: (");
        sb.append(this.uriMap.size());
        sb.append(" ontologies)\n");
        for (URI uri : this.uriMap.keySet()) {
            sb.append("    ");
            sb.append(uri);
            sb.append(" -> ");
            sb.append(this.uriMap.get(uri));
            sb.append("\n");
        }
        return sb.toString();
    }

    private class OWLXMLOntologyRootElementHandler
    implements OntologyRootElementHandler {
        private OWLXMLOntologyRootElementHandler() {
        }

        @Override
        public URI handle(Attributes attributes) {
            String ontURI = attributes.getValue(Namespaces.OWL2XML.toString(), "URI");
            if (ontURI == null) {
                ontURI = attributes.getValue("URI");
            }
            if (ontURI == null) {
                return null;
            }
            return URI.create(ontURI);
        }
    }

    private class RDFXMLOntologyRootElementHandler
    implements OntologyRootElementHandler {
        private RDFXMLOntologyRootElementHandler() {
        }

        @Override
        public URI handle(Attributes attributes) {
            String baseValue = attributes.getValue(Namespaces.XML.toString(), "base");
            if (baseValue == null) {
                return null;
            }
            return URI.create(baseValue);
        }
    }

    private static interface OntologyRootElementHandler {
        public URI handle(Attributes var1);
    }
}

