/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLCardinalityRestriction;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class DLExpressivityChecker
implements OWLObjectVisitor {
    private Set<Construct> constructs;
    private Set<OWLOntology> ontologies;

    public List<Construct> getConstructs() throws OWLException {
        return this.getOrderedConstructs();
    }

    public DLExpressivityChecker(Set<OWLOntology> ontologies) {
        this.ontologies = ontologies;
        this.constructs = new HashSet<Construct>();
    }

    public String getDescriptionLogicName() {
        List<Construct> orderedConstructs = this.getOrderedConstructs();
        String s = "";
        for (Construct c : orderedConstructs) {
            s = s + c.toString();
        }
        return s;
    }

    private void pruneConstructs() {
        if (this.constructs.contains((Object)Construct.AL)) {
            if (this.constructs.contains((Object)Construct.C)) {
                this.constructs.remove((Object)Construct.E);
                this.constructs.remove((Object)Construct.U);
            } else if (this.constructs.contains((Object)Construct.E) && this.constructs.contains((Object)Construct.U)) {
                this.constructs.add(Construct.AL);
                this.constructs.add(Construct.C);
                this.constructs.remove((Object)Construct.E);
                this.constructs.remove((Object)Construct.U);
            }
        }
        if (this.constructs.contains((Object)Construct.N) || this.constructs.contains((Object)Construct.Q)) {
            this.constructs.remove((Object)Construct.F);
        }
        if (this.constructs.contains((Object)Construct.Q)) {
            this.constructs.remove((Object)Construct.N);
        }
        if (this.constructs.contains((Object)Construct.AL) && this.constructs.contains((Object)Construct.C) && this.constructs.contains((Object)Construct.TRAN)) {
            this.constructs.remove((Object)Construct.AL);
            this.constructs.remove((Object)Construct.C);
            this.constructs.remove((Object)Construct.TRAN);
            this.constructs.add(Construct.S);
        }
        if (this.constructs.contains((Object)Construct.R)) {
            this.constructs.remove((Object)Construct.H);
        }
    }

    private List<Construct> getOrderedConstructs() {
        this.constructs.clear();
        this.constructs.add(Construct.AL);
        for (OWLOntology ont : this.ontologies) {
            for (OWLLogicalAxiom ax : ont.getLogicalAxioms()) {
                ax.accept(this);
            }
        }
        this.pruneConstructs();
        ArrayList<Construct> cons = new ArrayList<Construct>(this.constructs);
        Collections.sort(cons, new ConstructComparator());
        return cons;
    }

    @Override
    public void visit(OWLIndividual individual) {
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
    }

    @Override
    public void visit(OWLObjectProperty property) {
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        this.constructs.add(Construct.I);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDataType node) {
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLTypedConstant node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLClass desc) {
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.constructs.add(Construct.AL);
        for (OWLDescription operands : desc.getOperands()) {
            operands.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.constructs.add(Construct.U);
        for (OWLDescription operands : desc.getOperands()) {
            operands.accept(this);
        }
    }

    private boolean isTop(OWLDescription description) {
        if (!description.isAnonymous()) {
            return OWLRDFVocabulary.OWL_THING.getURI().equals(((OWLClass)description).getURI());
        }
        return false;
    }

    private boolean isAtomic(OWLDescription description) {
        if (description.isAnonymous()) {
            return false;
        }
        for (OWLOntology ont : this.ontologies) {
            if (ont.getAxioms((OWLClass)description).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        if (this.isAtomic(desc)) {
            this.constructs.add(Construct.AL);
        } else {
            this.constructs.add(Construct.C);
        }
        desc.getOperand().accept(this);
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        if (this.isTop((OWLDescription)desc.getFiller())) {
            this.constructs.add(Construct.AL);
        } else {
            this.constructs.add(Construct.E);
        }
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        if (this.isTop((OWLDescription)desc.getFiller())) {
            this.constructs.add(Construct.AL);
        } else {
            this.constructs.add(Construct.AL);
        }
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        this.constructs.add(Construct.O);
        this.constructs.add(Construct.E);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
    }

    private void checkCardinality(OWLCardinalityRestriction restriction) {
        if (restriction.isQualified()) {
            this.constructs.add(Construct.Q);
        } else {
            this.constructs.add(Construct.N);
        }
        restriction.getFiller().accept(this);
        restriction.getProperty().accept(this);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.constructs.add(Construct.R);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.O);
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        this.constructs.add(Construct.E);
        ((OWLDataRange)desc.getFiller()).accept(this);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        ((OWLDataRange)desc.getFiller()).accept(this);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.checkCardinality(desc);
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.constructs.add(Construct.C);
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        axiom.getDomain().accept(this);
        this.constructs.add(Construct.AL);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.constructs.add(Construct.AL);
        axiom.getDomain().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.H);
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.O);
        this.constructs.add(Construct.C);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.constructs.add(Construct.D);
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.R);
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.constructs.add(Construct.AL);
        ((OWLDescription)axiom.getRange()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.F);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        this.constructs.add(Construct.H);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.C);
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.I);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.constructs.add(Construct.AL);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.constructs.add(Construct.F);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.constructs.add(Construct.H);
        this.constructs.add(Construct.D);
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getDescription().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.TRAN);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        this.constructs.add(Construct.H);
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.I);
        this.constructs.add(Construct.F);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.constructs.add(Construct.O);
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.I);
    }

    @Override
    public void visit(SWRLRule rule) {
    }

    @Override
    public void visit(OWLOntology ontology) {
    }

    @Override
    public void visit(SWRLClassAtom node) {
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
    }

    private class ConstructComparator
    implements Comparator<Construct> {
        private List<Construct> order = new ArrayList<Construct>();

        public ConstructComparator() {
            this.order.add(Construct.S);
            this.order.add(Construct.AL);
            this.order.add(Construct.C);
            this.order.add(Construct.U);
            this.order.add(Construct.E);
            this.order.add(Construct.R);
            this.order.add(Construct.H);
            this.order.add(Construct.O);
            this.order.add(Construct.I);
            this.order.add(Construct.N);
            this.order.add(Construct.Q);
            this.order.add(Construct.F);
            this.order.add(Construct.TRAN);
            this.order.add(Construct.D);
        }

        @Override
        public int compare(Construct o1, Construct o2) {
            return this.order.indexOf((Object)o1) - this.order.indexOf((Object)o2);
        }
    }

    public static enum Construct {
        AL("AL"),
        U("U"),
        C("C"),
        E("E"),
        N("N"),
        Q("Q"),
        H("H"),
        I("I"),
        O("O"),
        F("F"),
        TRAN("+"),
        D("(D)"),
        R("R"),
        S("S"),
        EL("EL"),
        ELPLUSPLUS("EL++");

        private String s;

        private Construct(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

