/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.InferredAxiomGenerator;

public abstract class InferredEntityAxiomGenerator<E extends OWLEntity, A extends OWLAxiom>
implements InferredAxiomGenerator<A> {
    @Override
    public Set<A> createAxioms(OWLOntologyManager manager, OWLReasoner reasoner) throws OWLReasonerException {
        HashSet<OWLEntity> processedEntities = new HashSet<OWLEntity>();
        HashSet result = new HashSet();
        for (OWLOntology ont : reasoner.getLoadedOntologies()) {
            for (OWLEntity entity : this.getEntities(ont)) {
                if (processedEntities.contains(entity)) continue;
                processedEntities.add(entity);
                this.addAxioms(entity, reasoner, manager.getOWLDataFactory(), result);
            }
        }
        return result;
    }

    protected abstract void addAxioms(E var1, OWLReasoner var2, OWLDataFactory var3, Set<A> var4) throws OWLReasonerException;

    protected abstract Set<E> getEntities(OWLOntology var1);

    protected Set<E> getAllEntities(OWLReasoner reasoner) {
        HashSet<E> results = new HashSet<E>();
        for (OWLOntology ont : reasoner.getLoadedOntologies()) {
            results.addAll(this.getEntities(ont));
        }
        return results;
    }

    public String toString() {
        return this.getLabel();
    }
}

