/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owl.util.InferredIndividualAxiomGenerator;

public class InferredPropertyAssertionGenerator
extends InferredIndividualAxiomGenerator<OWLPropertyAssertionAxiom> {
    @Override
    protected void addAxioms(OWLIndividual entity, OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLPropertyAssertionAxiom> result) throws OWLReasonerException {
        Map<OWLObjectProperty, Set<OWLIndividual>> objectPropertyRels = reasoner.getObjectPropertyRelationships(entity);
        for (OWLObjectProperty prop : objectPropertyRels.keySet()) {
            for (OWLIndividual obj : objectPropertyRels.get(prop)) {
                result.add(dataFactory.getOWLObjectPropertyAssertionAxiom(entity, prop, obj));
            }
        }
        Map<OWLDataProperty, Set<OWLConstant>> dataPropertyRels = reasoner.getDataPropertyRelationships(entity);
        for (OWLDataProperty prop : dataPropertyRels.keySet()) {
            for (OWLConstant con : dataPropertyRels.get(prop)) {
                result.add(dataFactory.getOWLDataPropertyAssertionAxiom(entity, (OWLDataPropertyExpression)prop, con));
            }
        }
    }

    @Override
    public String getLabel() {
        return "Property assertions (property values)";
    }
}

