/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.HashSet;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDataVisitorEx;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitorEx;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLRule;

public class NNF
implements OWLDescriptionVisitorEx<OWLDescription>,
OWLDataVisitorEx<OWLDataRange>,
OWLAxiomVisitorEx<OWLAxiom> {
    private boolean negated;
    private OWLDataFactory dataFactory;

    public NNF(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public void reset() {
        this.negated = false;
    }

    private OWLDescription getNegation(OWLDescription description) {
        return this.dataFactory.getOWLObjectComplementOf(description);
    }

    @Override
    public OWLDescription visit(OWLClass desc) {
        if (this.negated) {
            return this.getNegation(desc);
        }
        return desc;
    }

    @Override
    public OWLDescription visit(OWLObjectIntersectionOf desc) {
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        for (OWLDescription op : desc.getOperands()) {
            ops.add(op.accept(this));
        }
        if (this.negated) {
            return this.dataFactory.getOWLObjectUnionOf(ops);
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    @Override
    public OWLDescription visit(OWLObjectUnionOf desc) {
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        for (OWLDescription op : desc.getOperands()) {
            ops.add(op.accept(this));
        }
        if (this.negated) {
            return this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    @Override
    public OWLDescription visit(OWLObjectComplementOf desc) {
        if (this.negated) {
            boolean neg = this.negated;
            this.negated = false;
            OWLDescription negDesc = desc.getOperand().accept(this);
            this.negated = neg;
            return negDesc;
        }
        boolean neg = this.negated;
        this.negated = true;
        OWLDescription negDesc = desc.getOperand().accept(this);
        this.negated = neg;
        return negDesc;
    }

    @Override
    public OWLDescription visit(OWLObjectSomeRestriction desc) {
        OWLDescription filler = ((OWLDescription)desc.getFiller()).accept(this);
        if (this.negated) {
            return this.dataFactory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)desc.getProperty(), filler);
        }
        return this.dataFactory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLDescription visit(OWLObjectAllRestriction desc) {
        OWLDescription filler = ((OWLDescription)desc.getFiller()).accept(this);
        if (this.negated) {
            return this.dataFactory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)desc.getProperty(), filler);
        }
        return this.dataFactory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLDescription visit(OWLObjectValueRestriction desc) {
        return desc.asSomeValuesFrom().accept(this);
    }

    @Override
    public OWLDescription visit(OWLObjectMinCardinalityRestriction desc) {
        boolean neg = this.negated;
        int card = desc.getCardinality();
        if (this.negated && (card = desc.getCardinality() - 1) < 0) {
            card = 0;
        }
        this.negated = false;
        OWLDescription filler = ((OWLDescription)desc.getFiller()).accept(this);
        OWLObjectCardinalityRestriction nnf = null;
        nnf = neg ? this.dataFactory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), card, filler) : this.dataFactory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), card, filler);
        this.negated = neg;
        return nnf;
    }

    @Override
    public OWLDescription visit(OWLObjectExactCardinalityRestriction desc) {
        return desc.asIntersectionOfMinMax().accept(this);
    }

    @Override
    public OWLDescription visit(OWLObjectMaxCardinalityRestriction desc) {
        boolean neg = this.negated;
        int card = desc.getCardinality();
        if (this.negated) {
            card = desc.getCardinality() + 1;
        }
        this.negated = false;
        OWLDescription filler = ((OWLDescription)desc.getFiller()).accept(this);
        OWLObjectCardinalityRestriction nnf = null;
        nnf = neg ? this.dataFactory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), card, filler) : this.dataFactory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), card, filler);
        this.negated = neg;
        return nnf;
    }

    @Override
    public OWLDescription visit(OWLObjectSelfRestriction desc) {
        if (this.negated) {
            return this.getNegation(desc);
        }
        return desc;
    }

    @Override
    public OWLDescription visit(OWLObjectOneOf desc) {
        if (desc.getIndividuals().size() == 1) {
            if (this.negated) {
                return this.getNegation(desc);
            }
            return desc;
        }
        return desc.asObjectUnionOf().accept(this);
    }

    @Override
    public OWLDescription visit(OWLDataSomeRestriction desc) {
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        if (this.negated) {
            return this.dataFactory.getOWLDataAllRestriction((OWLDataPropertyExpression)desc.getProperty(), filler);
        }
        return this.dataFactory.getOWLDataSomeRestriction((OWLDataPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLDescription visit(OWLDataAllRestriction desc) {
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        if (this.negated) {
            return this.dataFactory.getOWLDataSomeRestriction((OWLDataPropertyExpression)desc.getProperty(), filler);
        }
        return this.dataFactory.getOWLDataAllRestriction((OWLDataPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLDescription visit(OWLDataValueRestriction desc) {
        return desc.asSomeValuesFrom().accept(this);
    }

    @Override
    public OWLDescription visit(OWLDataExactCardinalityRestriction desc) {
        return desc.asIntersectionOfMinMax().accept(this);
    }

    @Override
    public OWLDescription visit(OWLDataMaxCardinalityRestriction desc) {
        boolean neg = this.negated;
        int card = desc.getCardinality();
        if (this.negated) {
            card = desc.getCardinality() + 1;
        }
        this.negated = false;
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataCardinalityRestriction nnf = null;
        nnf = neg ? this.dataFactory.getOWLDataMinCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), card, filler) : this.dataFactory.getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), card, filler);
        this.negated = neg;
        return nnf;
    }

    @Override
    public OWLDescription visit(OWLDataMinCardinalityRestriction desc) {
        boolean neg = this.negated;
        int card = desc.getCardinality();
        if (this.negated && (card = desc.getCardinality() - 1) < 0) {
            card = 0;
        }
        this.negated = false;
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataCardinalityRestriction nnf = null;
        nnf = neg ? this.dataFactory.getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), card, filler) : this.dataFactory.getOWLDataMinCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), card, filler);
        this.negated = neg;
        return nnf;
    }

    @Override
    public OWLDataRange visit(OWLDataType node) {
        if (this.negated) {
            return this.dataFactory.getOWLDataComplementOf(node);
        }
        return node;
    }

    @Override
    public OWLDataRange visit(OWLDataComplementOf node) {
        if (this.negated) {
            return node.getDataRange();
        }
        return node;
    }

    @Override
    public OWLDataRange visit(OWLDataOneOf node) {
        if (this.negated) {
            return this.dataFactory.getOWLDataComplementOf(node);
        }
        return node;
    }

    @Override
    public OWLDataRange visit(OWLDataRangeRestriction node) {
        if (this.negated) {
            return this.dataFactory.getOWLDataComplementOf(node);
        }
        return node;
    }

    @Override
    public OWLDataRange visit(OWLTypedConstant node) {
        return null;
    }

    @Override
    public OWLDataRange visit(OWLUntypedConstant node) {
        return null;
    }

    @Override
    public OWLDataRange visit(OWLDataRangeFacetRestriction node) {
        return null;
    }

    @Override
    public OWLAxiom visit(OWLSubClassAxiom axiom) {
        return this.dataFactory.getOWLSubClassAxiom(axiom.getSubClass().accept(this), axiom.getSuperClass().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointClassesAxiom axiom) {
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        for (OWLDescription op : axiom.getDescriptions()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLDisjointClassesAxiom(ops);
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyDomainAxiom axiom) {
        return this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getDomain().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLImportsDeclaration axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLAxiomAnnotationAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), axiom.getDomain().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDifferentIndividualsAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointDataPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), ((OWLDescription)axiom.getRange()).accept(this));
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLObjectSubPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointUnionAxiom axiom) {
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        for (OWLDescription op : axiom.getDescriptions()) {
            descs.add(op.accept(this));
        }
        return this.dataFactory.getOWLDisjointUnionAxiom(axiom.getOWLClass(), descs);
    }

    @Override
    public OWLAxiom visit(OWLDeclarationAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEntityAnnotationAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLOntologyAnnotationAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyRangeAxiom axiom) {
        return this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)axiom.getProperty(), ((OWLDataRange)axiom.getRange()).accept(this));
    }

    @Override
    public OWLAxiom visit(OWLFunctionalDataPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLClassAssertionAxiom axiom) {
        if (axiom.getDescription().isAnonymous()) {
            return this.dataFactory.getOWLClassAssertionAxiom(axiom.getIndividual(), axiom.getDescription().accept(this));
        }
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEquivalentClassesAxiom axiom) {
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        for (OWLDescription op : axiom.getDescriptions()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLEquivalentClassesAxiom(ops);
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDataSubPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSameIndividualsAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLInverseObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(SWRLRule rule) {
        return rule;
    }
}

