/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class OWLDataUtil {
    private static final URI INT_URI = XSDVocabulary.INT.getURI();
    private static Map<Class, XSDVocabulary> numberTypeMap = new HashMap<Class, XSDVocabulary>();

    public static OWLDataType getIntDataType(OWLDataFactory dataFactory) throws OWLException {
        return dataFactory.getOWLDataType(INT_URI);
    }

    public static OWLDataType getLongDataType(OWLDataFactory dataFactory) throws OWLException {
        return dataFactory.getOWLDataType(XSDVocabulary.LONG.getURI());
    }

    public static OWLDataType getFloatDataType(OWLDataFactory dataFactory) throws OWLException {
        return dataFactory.getOWLDataType(XSDVocabulary.FLOAT.getURI());
    }

    public static OWLDataType getDoubleDataType(OWLDataFactory dataFactory) throws OWLException {
        return dataFactory.getOWLDataType(XSDVocabulary.DOUBLE.getURI());
    }

    public static <N extends Number> OWLDataType getDataType(OWLDataFactory dataFactory, N n) {
        XSDVocabulary v = numberTypeMap.get(n.getClass());
        if (v == null) {
            throw new OWLRuntimeException("Don't know how to translate " + n.getClass());
        }
        return dataFactory.getOWLDataType(v.getURI());
    }

    public static Set<OWLDataRangeFacetRestriction> getFacetRestrictionSet(OWLDataFactory dataFactory, OWLRestrictedDataRangeFacetVocabulary facet, OWLTypedConstant facetValue) {
        return Collections.singleton(dataFactory.getOWLDataRangeFacetRestriction(facet, facetValue));
    }

    public static <N extends Number> OWLTypedConstant getTypedConstant(OWLDataFactory dataFactory, N val) {
        return dataFactory.getOWLTypedConstant(val.toString(), OWLDataUtil.getDataType(dataFactory, val));
    }

    public static <N extends Number> OWLDataRange getMinInclusiveRestrictedInt(OWLDataFactory dataFactory, N minInclusive) {
        return dataFactory.getOWLDataRangeRestriction((OWLDataRange)OWLDataUtil.getDataType(dataFactory, minInclusive), OWLDataUtil.getFacetRestrictionSet(dataFactory, OWLRestrictedDataRangeFacetVocabulary.MIN_INCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, minInclusive)));
    }

    public static <N extends Number> OWLDataRange getMinExclusiveRestrictedInt(OWLDataFactory dataFactory, N minExclusive) {
        return dataFactory.getOWLDataRangeRestriction((OWLDataRange)OWLDataUtil.getDataType(dataFactory, minExclusive), OWLDataUtil.getFacetRestrictionSet(dataFactory, OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, minExclusive)));
    }

    public static <N extends Number> OWLDataRange getMaxInclusiveRestrictedInteger(OWLDataFactory dataFactory, N maxInclusive) {
        return dataFactory.getOWLDataRangeRestriction((OWLDataRange)OWLDataUtil.getDataType(dataFactory, maxInclusive), OWLDataUtil.getFacetRestrictionSet(dataFactory, OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, maxInclusive)));
    }

    public static <N extends Number> OWLDataRange getMaxExclusiveRestrictedInteger(OWLDataFactory dataFactory, N maxExclusive) {
        return dataFactory.getOWLDataRangeRestriction((OWLDataRange)OWLDataUtil.getDataType(dataFactory, maxExclusive), OWLDataUtil.getFacetRestrictionSet(dataFactory, OWLRestrictedDataRangeFacetVocabulary.MAX_EXCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, maxExclusive)));
    }

    public static <N extends Number> OWLDataRange getMinMaxInclusiveRestrictedInteger(OWLDataFactory dataFactory, N minInclusive, N maxInclusive) {
        OWLDataType dr = OWLDataUtil.getDataType(dataFactory, minInclusive);
        HashSet<OWLDataRangeFacetRestriction> facetRestrictions = new HashSet<OWLDataRangeFacetRestriction>();
        facetRestrictions.add(dataFactory.getOWLDataRangeFacetRestriction(OWLRestrictedDataRangeFacetVocabulary.MIN_INCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, minInclusive)));
        facetRestrictions.add(dataFactory.getOWLDataRangeFacetRestriction(OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, maxInclusive)));
        return dataFactory.getOWLDataRangeRestriction((OWLDataRange)dr, facetRestrictions);
    }

    public static <N extends Number> OWLDataRange getMinMaxExclusiveRestrictedInteger(OWLDataFactory dataFactory, N minExclusive, N maxExclusive) {
        OWLDataType dr = OWLDataUtil.getDataType(dataFactory, minExclusive);
        HashSet<OWLDataRangeFacetRestriction> facetRestrictions = new HashSet<OWLDataRangeFacetRestriction>();
        facetRestrictions.add(dataFactory.getOWLDataRangeFacetRestriction(OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, minExclusive)));
        facetRestrictions.add(dataFactory.getOWLDataRangeFacetRestriction(OWLRestrictedDataRangeFacetVocabulary.MAX_EXCLUSIVE, OWLDataUtil.getTypedConstant(dataFactory, maxExclusive)));
        return dataFactory.getOWLDataRangeRestriction((OWLDataRange)dr, facetRestrictions);
    }

    static {
        numberTypeMap.put(Byte.class, XSDVocabulary.BYTE);
        numberTypeMap.put(Double.class, XSDVocabulary.DOUBLE);
        numberTypeMap.put(Float.class, XSDVocabulary.FLOAT);
        numberTypeMap.put(Integer.class, XSDVocabulary.INT);
        numberTypeMap.put(Short.class, XSDVocabulary.SHORT);
    }
}

