/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDataVisitor;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNaryBooleanDescription;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.model.OWLRestriction;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.util.OWLEntityComparator;
import org.semanticweb.owl.util.ShortFormProvider;

public class OWLDescriptionComparator
implements Comparator<OWLDescription> {
    private CoarseGrainedDescriptionComparator descriptionComparator;

    public OWLDescriptionComparator(ShortFormProvider shortFormProvider) {
        this.descriptionComparator = new CoarseGrainedDescriptionComparator(shortFormProvider);
    }

    @Override
    public int compare(OWLDescription o1, OWLDescription o2) {
        return this.descriptionComparator.compare(o1, o2);
    }

    private static abstract class AbstractOWLDescriptionComparator<O extends OWLDescription>
    extends AbstractOWLObjectComparator<O>
    implements OWLDescriptionVisitor {
        protected AbstractOWLDescriptionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }

        @Override
        public void visit(OWLClass desc) {
        }

        @Override
        public void visit(OWLDataAllRestriction desc) {
        }

        @Override
        public void visit(OWLDataExactCardinalityRestriction desc) {
        }

        @Override
        public void visit(OWLDataMaxCardinalityRestriction desc) {
        }

        @Override
        public void visit(OWLDataMinCardinalityRestriction desc) {
        }

        @Override
        public void visit(OWLDataSomeRestriction desc) {
        }

        @Override
        public void visit(OWLDataValueRestriction desc) {
        }

        @Override
        public void visit(OWLObjectAllRestriction desc) {
        }

        @Override
        public void visit(OWLObjectComplementOf desc) {
        }

        @Override
        public void visit(OWLObjectExactCardinalityRestriction desc) {
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
        }

        @Override
        public void visit(OWLObjectMaxCardinalityRestriction desc) {
        }

        @Override
        public void visit(OWLObjectMinCardinalityRestriction desc) {
        }

        @Override
        public void visit(OWLObjectOneOf desc) {
        }

        @Override
        public void visit(OWLObjectSelfRestriction desc) {
        }

        @Override
        public void visit(OWLObjectSomeRestriction desc) {
        }

        @Override
        public void visit(OWLObjectUnionOf desc) {
        }

        @Override
        public void visit(OWLObjectValueRestriction desc) {
        }
    }

    private static abstract class AbstractOWLObjectComparator<O extends OWLObject>
    implements Comparator<O> {
        private ShortFormProvider shortFormProvider;
        private Comparator<OWLObject> fineGrainedComparator;

        protected AbstractOWLObjectComparator(ShortFormProvider shortFormProvider) {
            this.shortFormProvider = shortFormProvider;
        }

        public void setFineGrainedComparator(Comparator fineGrainedComparator) {
            this.fineGrainedComparator = fineGrainedComparator;
        }

        protected abstract int compareObjects(O var1, O var2);

        @Override
        public int compare(O o1, O o2) {
            this.fineGrainedComparator = null;
            int delta = this.compareObjects(o1, o2);
            if (delta == 0 && this.fineGrainedComparator != null) {
                return this.fineGrainedComparator.compare((OWLObject)o1, (OWLObject)o2);
            }
            return delta;
        }

        protected String getShortForm(OWLEntity entity) {
            return this.shortFormProvider.getShortForm(entity);
        }

        public ShortFormProvider getShortFormProvider() {
            return this.shortFormProvider;
        }

        protected Comparator<? extends OWLObject> getFineGrainedComparator() {
            return this.fineGrainedComparator;
        }
    }

    public static class CoarseGrainedDescriptionComparator
    extends AbstractOWLDescriptionComparator<OWLDescription> {
        public static int OWL_CLASS = 0;
        public static int OWL_OBJECT_RESTRICTION = 1;
        public static int OWL_DATA_RESTRICTION = 2;
        public static int OWL_OBJECT_INTERSECTION_OF = 3;
        public static int OWL_OBJECT_UNION_OF = 4;
        public static int OWL_OBJECT_COMPLEMENT_OF = 5;
        public static int OWL_OBJECT_ONE_OF = 6;
        private OWLEntityComparator entityComparator;
        private OWLDataQuantifiedRestrictionComparator dataQuantifiedRestrictionComparator;
        private OWLDataCardinalityRestrictionComparator dataCardinalityRestrictionComparator;
        private OWLObjectCardinalityRestrictionComparator objectCardinalityRestrictionComparator;
        private OWLObjectQuantifiedRestrictionComparator objectQuantifiedRestrictionComparator;
        private OWLObjectComplementOfComparator objectComplementOfComparator;
        private NaryBooleanDescriptionComparator naryBooleanDescriptionComparator;
        private OWLSelfRestictionComparator selfRestictionComparator;
        private OWLObjectOneOfComparator objectOneOfComparator;
        private int lastValue;

        public CoarseGrainedDescriptionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
            this.entityComparator = new OWLEntityComparator(shortFormProvider);
            this.dataCardinalityRestrictionComparator = new OWLDataCardinalityRestrictionComparator(shortFormProvider);
            this.dataQuantifiedRestrictionComparator = new OWLDataQuantifiedRestrictionComparator(shortFormProvider);
            this.objectCardinalityRestrictionComparator = new OWLObjectCardinalityRestrictionComparator(shortFormProvider);
            this.objectQuantifiedRestrictionComparator = new OWLObjectQuantifiedRestrictionComparator(shortFormProvider);
            this.objectComplementOfComparator = new OWLObjectComplementOfComparator(shortFormProvider);
            this.naryBooleanDescriptionComparator = new NaryBooleanDescriptionComparator(shortFormProvider);
            this.selfRestictionComparator = new OWLSelfRestictionComparator(shortFormProvider);
            this.objectOneOfComparator = new OWLObjectOneOfComparator(shortFormProvider);
        }

        @Override
        protected int compareObjects(OWLDescription o1, OWLDescription o2) {
            o1.accept(this);
            int i1 = this.lastValue;
            o2.accept(this);
            int i2 = this.lastValue;
            return i1 - i2;
        }

        @Override
        public void visit(OWLClass desc) {
            this.lastValue = OWL_CLASS;
            this.setFineGrainedComparator(this.entityComparator);
        }

        @Override
        public void visit(OWLDataAllRestriction desc) {
            this.lastValue = OWL_DATA_RESTRICTION;
            this.setFineGrainedComparator(this.dataQuantifiedRestrictionComparator);
        }

        @Override
        public void visit(OWLDataExactCardinalityRestriction desc) {
            this.lastValue = OWL_DATA_RESTRICTION;
            this.setFineGrainedComparator(this.dataCardinalityRestrictionComparator);
        }

        @Override
        public void visit(OWLDataMaxCardinalityRestriction desc) {
            this.lastValue = OWL_DATA_RESTRICTION;
            this.setFineGrainedComparator(this.dataCardinalityRestrictionComparator);
        }

        @Override
        public void visit(OWLDataMinCardinalityRestriction desc) {
            this.lastValue = OWL_DATA_RESTRICTION;
            this.setFineGrainedComparator(this.dataCardinalityRestrictionComparator);
        }

        @Override
        public void visit(OWLDataSomeRestriction desc) {
            this.lastValue = OWL_DATA_RESTRICTION;
            this.setFineGrainedComparator(this.dataQuantifiedRestrictionComparator);
        }

        @Override
        public void visit(OWLDataValueRestriction desc) {
            this.lastValue = OWL_DATA_RESTRICTION;
            this.setFineGrainedComparator(this.dataQuantifiedRestrictionComparator);
        }

        @Override
        public void visit(OWLObjectAllRestriction desc) {
            this.lastValue = OWL_OBJECT_RESTRICTION;
            this.setFineGrainedComparator(this.objectQuantifiedRestrictionComparator);
        }

        @Override
        public void visit(OWLObjectComplementOf desc) {
            this.lastValue = OWL_OBJECT_COMPLEMENT_OF;
            this.setFineGrainedComparator(this.objectComplementOfComparator);
        }

        @Override
        public void visit(OWLObjectExactCardinalityRestriction desc) {
            this.lastValue = OWL_OBJECT_RESTRICTION;
            this.setFineGrainedComparator(this.objectCardinalityRestrictionComparator);
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            this.lastValue = OWL_OBJECT_INTERSECTION_OF;
            this.setFineGrainedComparator(this.naryBooleanDescriptionComparator);
        }

        @Override
        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            this.lastValue = OWL_OBJECT_RESTRICTION;
            this.setFineGrainedComparator(this.objectCardinalityRestrictionComparator);
        }

        @Override
        public void visit(OWLObjectMinCardinalityRestriction desc) {
            this.lastValue = OWL_OBJECT_RESTRICTION;
            this.setFineGrainedComparator(this.objectCardinalityRestrictionComparator);
        }

        @Override
        public void visit(OWLObjectOneOf desc) {
            this.lastValue = OWL_OBJECT_ONE_OF;
            this.setFineGrainedComparator(this.objectOneOfComparator);
        }

        @Override
        public void visit(OWLObjectSelfRestriction desc) {
            this.lastValue = OWL_OBJECT_RESTRICTION;
            this.setFineGrainedComparator(this.selfRestictionComparator);
        }

        @Override
        public void visit(OWLObjectSomeRestriction desc) {
            this.lastValue = OWL_OBJECT_RESTRICTION;
            this.setFineGrainedComparator(this.objectQuantifiedRestrictionComparator);
        }

        @Override
        public void visit(OWLObjectUnionOf desc) {
            this.lastValue = OWL_OBJECT_UNION_OF;
            this.setFineGrainedComparator(this.naryBooleanDescriptionComparator);
        }

        @Override
        public void visit(OWLObjectValueRestriction desc) {
            this.lastValue = OWL_OBJECT_RESTRICTION;
            this.setFineGrainedComparator(this.objectQuantifiedRestrictionComparator);
        }
    }

    private static class OWLDataCardinalityRestrictionComparator
    extends OWLDataQuantifiedRestrictionComparator {
        public OWLDataCardinalityRestrictionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }

        @Override
        public int compareObjects(OWLDataCardinalityRestriction o1, OWLDataCardinalityRestriction o2) {
            int delta = super.compare(o1, o2);
            if (delta != 0) {
                return 0;
            }
            return o1.getCardinality() - o2.getCardinality();
        }
    }

    private static class OWLDataQuantifiedRestrictionComparator
    extends OWLRestrictionComparator<OWLQuantifiedRestriction<OWLDataPropertyExpression, OWLDataRange>> {
        private OWLDataRangeComparator fillerComparator;

        public OWLDataQuantifiedRestrictionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
            this.fillerComparator = new OWLDataRangeComparator(shortFormProvider);
        }

        @Override
        protected int compareObjects(OWLQuantifiedRestriction<OWLDataPropertyExpression, OWLDataRange> o1, OWLQuantifiedRestriction<OWLDataPropertyExpression, OWLDataRange> o2) {
            int delta = super.compareObjects(o1, o2);
            if (delta != 0) {
                return delta;
            }
            return this.fillerComparator.compare(o1.getFiller(), o2.getFiller());
        }
    }

    private static class OWLObjectCardinalityRestrictionComparator
    extends OWLObjectQuantifiedRestrictionComparator {
        public OWLObjectCardinalityRestrictionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }

        @Override
        public int compareObjects(OWLObjectCardinalityRestriction o1, OWLObjectCardinalityRestriction o2) {
            int delta = super.compare(o1, o2);
            if (delta != 0) {
                return 0;
            }
            return o1.getCardinality() - o2.getCardinality();
        }
    }

    private static class OWLObjectQuantifiedRestrictionComparator
    extends OWLRestrictionComparator<OWLQuantifiedRestriction<OWLObjectPropertyExpression, OWLDescription>> {
        public OWLObjectQuantifiedRestrictionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }

        @Override
        protected int compareObjects(OWLQuantifiedRestriction<OWLObjectPropertyExpression, OWLDescription> o1, OWLQuantifiedRestriction<OWLObjectPropertyExpression, OWLDescription> o2) {
            int delta = super.compareObjects(o1, o2);
            if (delta != 0) {
                return delta;
            }
            CoarseGrainedDescriptionComparator fillerComparator = new CoarseGrainedDescriptionComparator(this.getShortFormProvider());
            return fillerComparator.compare(o1.getFiller(), o2.getFiller());
        }
    }

    private static class OWLObjectOneOfComparator
    extends AbstractOWLDescriptionComparator<OWLObjectOneOf> {
        private OWLEntityComparator entityComparator;

        public OWLObjectOneOfComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
            this.entityComparator = new OWLEntityComparator(shortFormProvider);
        }

        @Override
        protected int compareObjects(OWLObjectOneOf o1, OWLObjectOneOf o2) {
            ArrayList<OWLIndividual> indsA = new ArrayList<OWLIndividual>(o1.getIndividuals());
            ArrayList<OWLIndividual> indsB = new ArrayList<OWLIndividual>(o2.getIndividuals());
            Collections.sort(indsA, this.entityComparator);
            Collections.sort(indsB, this.entityComparator);
            int maxIndex = indsA.size() > indsB.size() ? indsB.size() : indsA.size();
            for (int i = 0; i < maxIndex; ++i) {
                OWLIndividual descB;
                OWLIndividual descA = (OWLIndividual)indsA.get(i);
                int delta = this.entityComparator.compare(descA, descB = (OWLIndividual)indsB.get(i));
                if (delta == 0) continue;
                return delta;
            }
            return indsA.size() - indsB.size();
        }
    }

    private static class OWLSelfRestictionComparator
    extends OWLRestrictionComparator<OWLObjectSelfRestriction> {
        public OWLSelfRestictionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }
    }

    private static class NaryBooleanDescriptionComparator
    extends AbstractOWLDescriptionComparator<OWLNaryBooleanDescription> {
        private CoarseGrainedDescriptionComparator descriptionComparator;

        public NaryBooleanDescriptionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }

        @Override
        protected int compareObjects(OWLNaryBooleanDescription o1, OWLNaryBooleanDescription o2) {
            CoarseGrainedDescriptionComparator descriptionComparator = new CoarseGrainedDescriptionComparator(this.getShortFormProvider());
            ArrayList<OWLDescription> descsA = new ArrayList<OWLDescription>(o1.getOperands());
            ArrayList<OWLDescription> descsB = new ArrayList<OWLDescription>(o2.getOperands());
            Collections.sort(descsA, descriptionComparator);
            Collections.sort(descsB, descriptionComparator);
            int maxIndex = descsA.size() > descsB.size() ? descsB.size() : descsA.size();
            for (int i = 0; i < maxIndex; ++i) {
                OWLDescription descB;
                OWLDescription descA = (OWLDescription)descsA.get(i);
                int delta = descriptionComparator.compare(descA, descB = (OWLDescription)descsB.get(i));
                if (delta == 0) continue;
                return delta;
            }
            return descsA.size() - descsB.size();
        }
    }

    private static class OWLObjectComplementOfComparator
    extends AbstractOWLDescriptionComparator<OWLObjectComplementOf> {
        public OWLObjectComplementOfComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }

        @Override
        protected int compareObjects(OWLObjectComplementOf o1, OWLObjectComplementOf o2) {
            CoarseGrainedDescriptionComparator descriptionComparator = new CoarseGrainedDescriptionComparator(this.getShortFormProvider());
            return descriptionComparator.compare(o1.getOperand(), o2.getOperand());
        }
    }

    private static class OWLDataRangeComparator
    extends AbstractOWLObjectComparator<OWLDataRange>
    implements OWLDataVisitor {
        public OWLDataRangeComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }

        @Override
        protected int compareObjects(OWLDataRange o1, OWLDataRange o2) {
            return 0;
        }

        @Override
        public void visit(OWLDataComplementOf node) {
        }

        @Override
        public void visit(OWLDataOneOf node) {
        }

        @Override
        public void visit(OWLDataRangeFacetRestriction node) {
        }

        @Override
        public void visit(OWLDataRangeRestriction node) {
        }

        @Override
        public void visit(OWLDataType node) {
        }

        @Override
        public void visit(OWLTypedConstant node) {
        }

        @Override
        public void visit(OWLUntypedConstant node) {
        }
    }

    private static abstract class OWLRestrictionComparator<R extends OWLRestriction>
    extends AbstractOWLDescriptionComparator<R> {
        public static final int OBJECT_SOME = 0;
        public static final int OBJECT_MIN = 1;
        public static final int OBJECT_MAX = 2;
        public static final int OBJECT_EXACT = 3;
        public static final int OBJECT_SELF = 4;
        public static final int OBJECT_VALUE = 5;
        public static final int OBJECT_ALL = 6;
        public static final int DATA_SOME = 7;
        public static final int DATA_MIN = 8;
        public static final int DATA_MAX = 9;
        public static final int DATA_EXACT = 10;
        public static final int DATA_VALUE = 11;
        public static final int DATA_ALL = 12;
        private int typeIndex;
        private OWLPropertyExpressionComparator propertyComparator;

        public OWLRestrictionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
            this.propertyComparator = new OWLPropertyExpressionComparator(shortFormProvider);
        }

        @Override
        protected int compareObjects(R o1, R o2) {
            Object prop2;
            Object prop1 = o1.getProperty();
            int delta = this.propertyComparator.compare(prop1, prop2 = o2.getProperty());
            if (delta != 0) {
                return delta;
            }
            o1.accept(this);
            int type1 = this.typeIndex;
            o2.accept(this);
            int type2 = this.typeIndex;
            return type1 - type2;
        }

        @Override
        public void visit(OWLDataAllRestriction desc) {
            this.typeIndex = 12;
        }

        @Override
        public void visit(OWLDataExactCardinalityRestriction desc) {
            this.typeIndex = 10;
        }

        @Override
        public void visit(OWLDataMaxCardinalityRestriction desc) {
            this.typeIndex = 9;
        }

        @Override
        public void visit(OWLDataMinCardinalityRestriction desc) {
            this.typeIndex = 8;
        }

        @Override
        public void visit(OWLDataSomeRestriction desc) {
            this.typeIndex = 7;
        }

        @Override
        public void visit(OWLDataValueRestriction desc) {
            this.typeIndex = 11;
        }

        @Override
        public void visit(OWLObjectAllRestriction desc) {
            this.typeIndex = 6;
        }

        @Override
        public void visit(OWLObjectExactCardinalityRestriction desc) {
            this.typeIndex = 3;
        }

        @Override
        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            this.typeIndex = 2;
        }

        @Override
        public void visit(OWLObjectMinCardinalityRestriction desc) {
            this.typeIndex = 1;
        }

        @Override
        public void visit(OWLObjectSelfRestriction desc) {
            this.typeIndex = 4;
        }

        @Override
        public void visit(OWLObjectSomeRestriction desc) {
            this.typeIndex = 0;
        }

        @Override
        public void visit(OWLObjectValueRestriction desc) {
            this.typeIndex = 5;
        }
    }

    public static class OWLPropertyExpressionComparator
    extends AbstractOWLObjectComparator<OWLPropertyExpression>
    implements OWLPropertyExpressionVisitor {
        private int lastValue;

        public OWLPropertyExpressionComparator(ShortFormProvider shortFormProvider) {
            super(shortFormProvider);
        }

        @Override
        public int compareObjects(OWLPropertyExpression o1, OWLPropertyExpression o2) {
            o1.accept(this);
            int i1 = this.lastValue;
            o2.accept(this);
            int i2 = this.lastValue;
            int delta = i2 - i1;
            if (delta == 0) {
                if (o1.isAnonymous()) {
                    return this.compare(((OWLObjectPropertyInverse)o1).getInverse(), ((OWLObjectPropertyInverse)o2).getInverse());
                }
                String s1 = this.getShortForm((OWLProperty)o1);
                String s2 = this.getShortForm((OWLProperty)o2);
                return s1.compareTo(s2);
            }
            return delta;
        }

        @Override
        public void visit(OWLDataProperty property) {
            this.lastValue = 0;
        }

        @Override
        public void visit(OWLObjectProperty property) {
            this.lastValue = 1;
        }

        @Override
        public void visit(OWLObjectPropertyInverse property) {
            this.lastValue = 2;
        }
    }
}

