/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.model.OWLAxiomChange;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeListener;

public abstract class OWLEntityCollectingOntologyChangeListener
implements OWLOntologyChangeListener {
    private Set<OWLEntity> entities = new HashSet<OWLEntity>();

    @Override
    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        this.entities.clear();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            OWLAxiomChange axiomChange = (OWLAxiomChange)oWLOntologyChange;
            this.entities.addAll(axiomChange.getEntities());
        }
        this.ontologiesChanged();
    }

    public abstract void ontologiesChanged() throws OWLException;

    public Set<OWLEntity> getEntities() {
        return Collections.unmodifiableSet(this.entities);
    }
}

