/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Comparator;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.util.ShortFormProvider;

public class OWLEntityComparator
implements Comparator<OWLEntity>,
OWLEntityVisitor {
    int lastValue;
    public static final int OWL_CLASS_INDEX = 0;
    public static final int OWL_OBJECT_PROPERTY_INDEX = 1;
    public static final int OWL_DATA_PROPERTY_INDEX = 2;
    public static final int OWL_INDIVIDUAL_INDEX = 3;
    public static final int OWL_DATATYPE_INDEX = 4;
    private ShortFormProvider shortFormProvider;

    public OWLEntityComparator(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    @Override
    public int compare(OWLEntity o1, OWLEntity o2) {
        o1.accept(this);
        int i1 = this.lastValue;
        o2.accept(this);
        int i2 = this.lastValue;
        int delta = i1 - i2;
        if (delta != 0) {
            return delta;
        }
        String s1 = this.getShortForm(o1);
        String s2 = this.getShortForm(o2);
        return s1.compareTo(s2);
    }

    private String getShortForm(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    @Override
    public void visit(OWLClass cls) {
        this.lastValue = 0;
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.lastValue = 1;
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.lastValue = 2;
    }

    @Override
    public void visit(OWLIndividual individual) {
        this.lastValue = 3;
    }

    @Override
    public void visit(OWLDataType dataType) {
        this.lastValue = 4;
    }
}

