/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.OWLEntityURIConverterStrategy;
import org.semanticweb.owl.util.OWLObjectDuplicator;

public class OWLEntityURIConverter {
    private OWLOntologyManager manager;
    private Set<OWLOntology> ontologies;
    private Map<OWLEntity, URI> replacementMap;
    private List<OWLOntologyChange> changes;
    private Set<OWLEntity> processedEntities;
    private OWLEntityURIConverterStrategy strategy;

    public OWLEntityURIConverter(OWLOntologyManager manager, Set<OWLOntology> ontologies, OWLEntityURIConverterStrategy strategy) {
        this.manager = manager;
        this.ontologies = new HashSet<OWLOntology>(ontologies);
        this.strategy = strategy;
    }

    public List<OWLOntologyChange> getChanges() {
        this.replacementMap = new HashMap<OWLEntity, URI>();
        this.processedEntities = new HashSet<OWLEntity>();
        this.changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLClass oWLClass : ont.getReferencedClasses()) {
                if (oWLClass.isOWLThing() || oWLClass.isOWLNothing()) continue;
                this.processEntity(oWLClass);
            }
            for (OWLObjectProperty oWLObjectProperty : ont.getReferencedObjectProperties()) {
                this.processEntity(oWLObjectProperty);
            }
            for (OWLDataProperty oWLDataProperty : ont.getReferencedDataProperties()) {
                this.processEntity(oWLDataProperty);
            }
            for (OWLIndividual oWLIndividual : ont.getReferencedIndividuals()) {
                this.processEntity(oWLIndividual);
            }
        }
        OWLObjectDuplicator dup = new OWLObjectDuplicator(this.replacementMap, this.manager.getOWLDataFactory());
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getAxioms()) {
                OWLAxiom dupAx = (OWLAxiom)dup.duplicateObject(ax);
                if (dupAx.equals(ax)) continue;
                this.changes.add(new RemoveAxiom(ont, ax));
                this.changes.add(new AddAxiom(ont, dupAx));
            }
        }
        return this.changes;
    }

    private void processEntity(OWLEntity ent) {
        if (this.processedEntities.contains(ent)) {
            return;
        }
        URI rep = this.getTinyURI(ent);
        this.replacementMap.put(ent, rep);
        this.processedEntities.add(ent);
    }

    private URI getTinyURI(OWLEntity ent) {
        return this.strategy.getConvertedURI(ent);
    }
}

