/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.util.OWLEntityURIConverterStrategy;

public class OWLEntityURIUnderscores2CamelBackConverterStrategy
implements OWLEntityURIConverterStrategy {
    private Map<URI, URI> uriMap = new HashMap<URI, URI>();

    @Override
    public URI getConvertedURI(OWLEntity entity) {
        URI convURI = this.uriMap.get(entity.getURI());
        if (convURI == null) {
            convURI = OWLEntityURIUnderscores2CamelBackConverterStrategy.convertURI(entity.getURI());
            this.uriMap.put(entity.getURI(), convURI);
        }
        return convURI;
    }

    private static URI convertURI(URI uri) {
        String uriString = uri.toString();
        String fragment = uri.getFragment();
        if (fragment != null) {
            String base = uriString.substring(0, uriString.length() - fragment.length());
            String camelCaseFragment = OWLEntityURIUnderscores2CamelBackConverterStrategy.toCamelCase(fragment);
            return URI.create(base + camelCaseFragment);
        }
        String path = uri.getPath();
        if (path.length() > 0) {
            int index = path.lastIndexOf(47);
            String lastPathElement = path.substring(index + 1, path.length());
            String camelCaseElement = OWLEntityURIUnderscores2CamelBackConverterStrategy.toCamelCase(lastPathElement);
            String base = uriString.substring(0, uriString.lastIndexOf(47) + 1);
            return URI.create(base + camelCaseElement);
        }
        return uri;
    }

    private static String toCamelCase(String s) {
        StringBuilder sb = new StringBuilder();
        boolean nextIsUpperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '_') {
                nextIsUpperCase = true;
                continue;
            }
            if (nextIsUpperCase) {
                sb.append(Character.toUpperCase(ch));
                nextIsUpperCase = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        URI uri = URI.create("http://www.another.co");
        System.out.println(uri);
        System.out.println(OWLEntityURIUnderscores2CamelBackConverterStrategy.convertURI(uri));
    }
}

