/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class OWLObjectPropertyManager {
    private OWLOntologyManager man;
    private OWLOntology ontology;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> hierarchy;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> reflexiveTransitiveClosure;
    private Set<OWLObjectPropertyExpression> compositeProperties;
    private Set<OWLObjectPropertyExpression> nonSimpleProperties;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> partialOrdering;
    private boolean compositeDirty;
    private boolean hierarchyDirty;
    private boolean reflexiveTransitiveClosureDirty;
    private boolean simpleDirty;
    private boolean partialOrderingDirty;

    public OWLObjectPropertyManager(OWLOntologyManager manager, OWLOntology ont) {
        this.man = manager;
        this.hierarchy = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        this.reflexiveTransitiveClosure = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        this.compositeProperties = new HashSet<OWLObjectPropertyExpression>();
        this.nonSimpleProperties = new HashSet<OWLObjectPropertyExpression>();
        this.partialOrdering = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        this.setOntology(ont);
    }

    private void reset() {
        this.compositeDirty = true;
        this.hierarchyDirty = true;
        this.reflexiveTransitiveClosureDirty = true;
        this.simpleDirty = true;
        this.partialOrderingDirty = true;
    }

    public void dispose() {
    }

    public void setOntology(OWLOntology ontology) {
        this.ontology = ontology;
        this.reset();
    }

    protected Set<OWLOntology> getOntologies() {
        return this.man.getImportsClosure(this.ontology);
    }

    public boolean isComposite(OWLObjectPropertyExpression expression) {
        return this.getCompositeProperties().contains(expression.getSimplified());
    }

    public Set<OWLObjectPropertyExpression> getCompositeProperties() {
        if (this.compositeDirty) {
            this.compositeProperties.clear();
            this.compositeProperties.add(this.man.getOWLDataFactory().getOWLObjectProperty(OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getURI()));
            this.compositeProperties.add(this.man.getOWLDataFactory().getOWLObjectProperty(OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getURI()));
            for (OWLOntology ont : this.getOntologies()) {
                for (OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom : ont.getAxioms(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
                    this.markComposite((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty());
                    for (OWLObjectPropertyExpression namedInv : ((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()).getInverses(this.ontology)) {
                        this.markComposite(namedInv);
                    }
                }
                for (OWLObjectPropertyChainSubPropertyAxiom oWLObjectPropertyChainSubPropertyAxiom : ont.getPropertyChainSubPropertyAxioms()) {
                    this.markComposite(oWLObjectPropertyChainSubPropertyAxiom.getSuperProperty());
                    for (OWLObjectPropertyExpression namedInv : oWLObjectPropertyChainSubPropertyAxiom.getSuperProperty().getInverses(this.ontology)) {
                        this.markComposite(namedInv);
                    }
                }
            }
            this.compositeDirty = false;
        }
        return this.compositeProperties;
    }

    private void markComposite(OWLObjectPropertyExpression prop) {
        this.compositeProperties.add(prop.getSimplified());
        this.compositeProperties.add(prop.getInverseProperty().getSimplified());
    }

    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getPropertyHierarchy() {
        if (this.hierarchyDirty) {
            HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
            for (OWLOntology ont : this.getOntologies()) {
                for (OWLObjectSubPropertyAxiom oWLObjectSubPropertyAxiom : ont.getAxioms(AxiomType.SUB_OBJECT_PROPERTY)) {
                    OWLObjectPropertyManager.getKeyValue(((OWLObjectPropertyExpression)oWLObjectSubPropertyAxiom.getSubProperty()).getSimplified(), map).add(((OWLObjectPropertyExpression)oWLObjectSubPropertyAxiom.getSuperProperty()).getSimplified());
                    OWLObjectPropertyManager.getKeyValue(((OWLObjectPropertyExpression)oWLObjectSubPropertyAxiom.getSubProperty()).getInverseProperty().getSimplified(), map).add(((OWLObjectPropertyExpression)oWLObjectSubPropertyAxiom.getSuperProperty()).getInverseProperty().getSimplified());
                }
                for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ont.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
                    for (OWLObjectPropertyExpression propA : oWLEquivalentObjectPropertiesAxiom.getProperties()) {
                        for (OWLObjectPropertyExpression propB : oWLEquivalentObjectPropertiesAxiom.getProperties()) {
                            if (propA.equals(propB)) continue;
                            OWLObjectPropertyManager.getKeyValue(propA.getSimplified(), map).add(propB.getSimplified());
                            OWLObjectPropertyManager.getKeyValue(propB.getSimplified(), map).add(propA.getSimplified());
                            OWLObjectPropertyManager.getKeyValue(propA.getInverseProperty().getSimplified(), map).add(propB.getInverseProperty().getSimplified());
                            OWLObjectPropertyManager.getKeyValue(propB.getInverseProperty().getSimplified(), map).add(propA.getInverseProperty().getSimplified());
                        }
                    }
                }
                for (OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom : ont.getAxioms(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
                    OWLObjectPropertyManager.getKeyValue(oWLInverseObjectPropertiesAxiom.getFirstProperty().getSimplified(), map).add(oWLInverseObjectPropertiesAxiom.getSecondProperty().getInverseProperty().getSimplified());
                    OWLObjectPropertyManager.getKeyValue(oWLInverseObjectPropertiesAxiom.getSecondProperty().getInverseProperty().getSimplified(), map).add(oWLInverseObjectPropertiesAxiom.getFirstProperty().getSimplified());
                    OWLObjectPropertyManager.getKeyValue(oWLInverseObjectPropertiesAxiom.getFirstProperty().getInverseProperty().getSimplified(), map).add(oWLInverseObjectPropertiesAxiom.getSecondProperty().getSimplified());
                    OWLObjectPropertyManager.getKeyValue(oWLInverseObjectPropertiesAxiom.getSecondProperty().getSimplified(), map).add(oWLInverseObjectPropertiesAxiom.getFirstProperty().getInverseProperty().getSimplified());
                }
                for (OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom : ont.getAxioms(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                    OWLObjectPropertyManager.getKeyValue(((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).getSimplified(), map).add(((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).getInverseProperty().getSimplified());
                    OWLObjectPropertyManager.getKeyValue(((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).getInverseProperty().getSimplified(), map).add(((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).getSimplified());
                }
            }
            this.hierarchy.clear();
            this.hierarchy.putAll(map);
            this.hierarchyDirty = false;
        }
        return this.hierarchy;
    }

    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getHierarchyReflexiveTransitiveClosure() {
        if (this.reflexiveTransitiveClosureDirty) {
            HashMap<OWLObjectPropertyExpression, HashSet<OWLObjectPropertyExpression>> rtcMap = new HashMap<OWLObjectPropertyExpression, HashSet<OWLObjectPropertyExpression>>();
            Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> hierarchy = this.getPropertyHierarchy();
            for (OWLObjectPropertyExpression prop : this.getReferencedProperties()) {
                HashSet<OWLObjectPropertyExpression> processed = new HashSet<OWLObjectPropertyExpression>();
                HashSet<OWLObjectPropertyExpression> rtc = new HashSet<OWLObjectPropertyExpression>();
                OWLObjectPropertyManager.getReflexiveTransitiveClosure(prop, hierarchy, rtc, processed);
                rtcMap.put(prop, rtc);
            }
            this.reflexiveTransitiveClosure.clear();
            this.reflexiveTransitiveClosure.putAll(rtcMap);
            this.reflexiveTransitiveClosureDirty = false;
        }
        return this.reflexiveTransitiveClosure;
    }

    public boolean isSubPropertyOf(OWLObjectPropertyExpression sub, OWLObjectPropertyExpression sup) {
        Set<OWLObjectPropertyExpression> supers = this.getHierarchyReflexiveTransitiveClosure().get(sub);
        if (supers == null) {
            return false;
        }
        return supers.contains(sup);
    }

    public boolean isNonSimple(OWLObjectPropertyExpression expression) {
        return this.getNonSimpleProperties().contains(expression.getSimplified());
    }

    public Set<OWLObjectPropertyExpression> getNonSimpleProperties() {
        if (this.simpleDirty) {
            this.nonSimpleProperties.clear();
            Set<OWLObjectPropertyExpression> props = this.getReferencedProperties();
            Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> reflexiveTransitiveClosure = this.getHierarchyReflexiveTransitiveClosure();
            for (OWLObjectPropertyExpression prop : this.getReferencedProperties()) {
                if (!this.isComposite(prop)) continue;
                Set<OWLObjectPropertyExpression> rtc = reflexiveTransitiveClosure.get(prop);
                props.removeAll(rtc);
                this.nonSimpleProperties.add(prop);
                this.nonSimpleProperties.addAll(rtc);
            }
            for (OWLObjectPropertyExpression prop : new HashSet<OWLObjectPropertyExpression>(this.nonSimpleProperties)) {
                this.nonSimpleProperties.add(prop.getInverseProperty().getSimplified());
            }
            this.simpleDirty = false;
        }
        return this.nonSimpleProperties;
    }

    public Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> getPropertyPartialOrdering() {
        if (this.partialOrderingDirty) {
            this.partialOrdering.clear();
            HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>(this.getPropertyHierarchy());
            for (OWLOntology ont : this.getOntologies()) {
                for (OWLObjectPropertyChainSubPropertyAxiom ax : ont.getPropertyChainSubPropertyAxioms()) {
                    for (OWLObjectPropertyExpression prop : ax.getPropertyChain()) {
                        HashSet<OWLObjectPropertyExpression> sups = (HashSet<OWLObjectPropertyExpression>)map.get(prop.getSimplified());
                        if (sups == null) {
                            sups = new HashSet<OWLObjectPropertyExpression>();
                            map.put(prop, sups);
                        }
                        sups.add(ax.getSuperProperty().getSimplified());
                        HashSet<OWLObjectPropertyExpression> supsInv = (HashSet<OWLObjectPropertyExpression>)map.get(prop.getInverseProperty().getSimplified());
                        if (supsInv == null) {
                            supsInv = new HashSet<OWLObjectPropertyExpression>();
                            map.put(prop.getInverseProperty().getSimplified(), supsInv);
                        }
                        supsInv.add(ax.getSuperProperty().getInverseProperty().getSimplified());
                    }
                }
            }
            HashMap<OWLObjectPropertyExpression, HashSet<OWLObjectPropertyExpression>> ordering = new HashMap<OWLObjectPropertyExpression, HashSet<OWLObjectPropertyExpression>>();
            for (OWLObjectPropertyExpression prop : this.getReferencedProperties()) {
                HashSet<OWLObjectPropertyExpression> processed = new HashSet<OWLObjectPropertyExpression>();
                HashSet<OWLObjectPropertyExpression> rtc = new HashSet<OWLObjectPropertyExpression>();
                OWLObjectPropertyManager.getReflexiveTransitiveClosure(prop, map, rtc, processed);
                ordering.put(prop, rtc);
            }
            this.partialOrdering.putAll(ordering);
            this.partialOrderingDirty = false;
        }
        return this.partialOrdering;
    }

    public boolean isLessThan(OWLObjectPropertyExpression propA, OWLObjectPropertyExpression propB) {
        Set<OWLObjectPropertyExpression> props = this.getPropertyPartialOrdering().get(propA.getSimplified());
        if (props == null) {
            return false;
        }
        return props.contains(propB.getSimplified());
    }

    private Set<OWLObjectPropertyExpression> getReferencedProperties() {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLObjectProperty prop : ont.getReferencedObjectProperties()) {
                props.add(prop.getSimplified());
            }
        }
        return props;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<Set<OWLObjectPropertyExpression>> getEquivalentObjectProperties(Set<OWLOntology> ontologies) {
        void var5_9;
        HashSet<Set<OWLObjectPropertyExpression>> result = new HashSet<Set<OWLObjectPropertyExpression>>();
        HashSet<OWLObjectPropertyExpression> processed = new HashSet<OWLObjectPropertyExpression>();
        HashSet<OWLObjectProperty> properties = new HashSet<OWLObjectProperty>();
        for (OWLOntology oWLOntology : ontologies) {
            properties.addAll(oWLOntology.getReferencedObjectProperties());
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : properties) {
            if (processed.contains(oWLObjectPropertyExpression)) continue;
            OWLObjectPropertyManager.tarjan(ontologies, oWLObjectPropertyExpression, 0, new Stack<OWLObjectPropertyExpression>(), new HashMap<OWLObjectPropertyExpression, Integer>(), new HashMap<OWLObjectPropertyExpression, Integer>(), result, processed, new HashSet<OWLObjectPropertyExpression>());
        }
        ArrayList<Set<OWLObjectPropertyExpression>> equivs = new ArrayList<Set<OWLObjectPropertyExpression>>(result);
        Collections.sort(equivs, new Comparator<Set<OWLObjectPropertyExpression>>(){

            @Override
            public int compare(Set<OWLObjectPropertyExpression> o1, Set<OWLObjectPropertyExpression> o2) {
                return o1.size() - o2.size();
            }
        });
        boolean bl = false;
        while (var5_9 < equivs.size()) {
            Set first = (Set)equivs.get((int)var5_9);
            for (void j = var5_9; j < equivs.size(); ++j) {
                Set second = (Set)equivs.get((int)j);
                if (second.size() <= first.size() || !second.containsAll(first)) continue;
                equivs.remove((int)var5_9);
                break;
            }
            ++var5_9;
        }
        for (OWLOntology ont : ontologies) {
            for (OWLEquivalentObjectPropertiesAxiom ax : ont.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            }
        }
        return equivs;
    }

    public Collection<Set<OWLObjectPropertyExpression>> getEquivalentObjectProperties() {
        return OWLObjectPropertyManager.getEquivalentObjectProperties(this.getOntologies());
    }

    public static void tarjan(Set<OWLOntology> ontologies, OWLObjectPropertyExpression prop, int index, Stack<OWLObjectPropertyExpression> stack, Map<OWLObjectPropertyExpression, Integer> indexMap, Map<OWLObjectPropertyExpression, Integer> lowlinkMap, Set<Set<OWLObjectPropertyExpression>> result, Set<OWLObjectPropertyExpression> processed, Set<OWLObjectPropertyExpression> stackProps) {
        processed.add(prop);
        indexMap.put(prop, index);
        lowlinkMap.put(prop, index);
        ++index;
        stack.push(prop);
        stackProps.add(prop);
        for (OWLOntology ont : ontologies) {
            for (OWLObjectSubPropertyAxiom ax : ont.getObjectSubPropertyAxiomsForLHS(prop)) {
                if (!((OWLObjectPropertyExpression)ax.getSubProperty()).equals(prop)) continue;
                OWLObjectPropertyExpression supProp = (OWLObjectPropertyExpression)ax.getSuperProperty();
                if (!indexMap.containsKey(supProp)) {
                    OWLObjectPropertyManager.tarjan(ontologies, supProp, index, stack, indexMap, lowlinkMap, result, processed, stackProps);
                    lowlinkMap.put(prop, Math.min(lowlinkMap.get(prop), lowlinkMap.get(supProp)));
                    continue;
                }
                if (!stackProps.contains(supProp)) continue;
                lowlinkMap.put(prop, Math.min(lowlinkMap.get(prop), indexMap.get(supProp)));
            }
        }
        if (lowlinkMap.get(prop).equals(indexMap.get(prop))) {
            OWLObjectPropertyExpression propPrime;
            HashSet<OWLObjectPropertyExpression> scc = new HashSet<OWLObjectPropertyExpression>();
            do {
                propPrime = stack.pop();
                stackProps.remove(propPrime);
                scc.add(propPrime);
            } while (!propPrime.equals(prop));
            if (scc.size() > 1) {
                result.add(scc);
            }
        }
    }

    private static void getReflexiveTransitiveClosure(OWLObjectPropertyExpression prop, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, Set<OWLObjectPropertyExpression> rtc, Set<OWLObjectPropertyExpression> processed) {
        if (processed.contains(prop)) {
            return;
        }
        rtc.add(prop);
        processed.add(prop);
        Set<OWLObjectPropertyExpression> supers = map.get(prop);
        if (supers == null) {
            return;
        }
        for (OWLObjectPropertyExpression sup : supers) {
            OWLObjectPropertyManager.getReflexiveTransitiveClosure(sup, map, rtc, processed);
        }
    }

    private static Set<OWLObjectPropertyExpression> getKeyValue(OWLObjectPropertyExpression key, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map) {
        Set<OWLObjectPropertyExpression> vals = map.get(key);
        if (vals == null) {
            vals = new HashSet<OWLObjectPropertyExpression>(4);
            map.put(key, vals);
        }
        return vals;
    }
}

