/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLObjectVisitor;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;

public class SWRLVariableExtractor
implements SWRLObjectVisitor {
    private Set<SWRLAtomDVariable> dvariables = new HashSet<SWRLAtomDVariable>();
    private Set<SWRLAtomIVariable> ivariables = new HashSet<SWRLAtomIVariable>();

    public Set<SWRLAtomDVariable> getDVariables() {
        return Collections.unmodifiableSet(this.dvariables);
    }

    public Set<SWRLAtomIVariable> getIVariables() {
        return Collections.unmodifiableSet(this.ivariables);
    }

    public void reset() {
        this.dvariables.clear();
        this.ivariables.clear();
    }

    @Override
    public void visit(SWRLRule node) {
        for (SWRLAtom atom : node.getBody()) {
            atom.accept(this);
        }
        for (SWRLAtom atom : node.getHead()) {
            atom.accept(this);
        }
    }

    @Override
    public void visit(SWRLClassAtom node) {
        ((SWRLAtomIObject)node.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        ((SWRLAtomDObject)node.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomDObject)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        for (SWRLAtomDObject o : node.getArguments()) {
            o.accept(this);
        }
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        this.dvariables.add(node);
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        this.ivariables.add(node);
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
    }
}

