/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomChange;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owl.util.OWLDescriptionVisitorAdapter;
import org.semanticweb.owl.util.SimpleRootClassChecker;

public class ToldClassHierarchyReasoner
implements OWLClassReasoner {
    private OWLOntologyManager manager;
    private Set<OWLOntology> ontologies;
    private OWLClass root;
    private ParentClassExtractor parentClassExtractor;
    private ChildClassExtractor childClassExtractor;
    private OWLOntologyChangeListener listener;
    private Set<OWLClass> implicitRoots;
    private SimpleRootClassChecker checker;

    public ToldClassHierarchyReasoner(OWLOntologyManager owlOntologyManager) {
        this.manager = owlOntologyManager;
        this.ontologies = new HashSet<OWLOntology>();
        this.implicitRoots = new HashSet<OWLClass>();
        this.parentClassExtractor = new ParentClassExtractor();
        this.childClassExtractor = new ChildClassExtractor();
        this.listener = new OWLOntologyChangeListener(){

            @Override
            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
                ToldClassHierarchyReasoner.this.handleChanges(changes);
            }
        };
        this.getManager().addOntologyChangeListener(this.listener);
    }

    private OWLOntologyManager getManager() {
        return this.manager;
    }

    @Override
    public void dispose() {
        this.getManager().removeOntologyChangeListener(this.listener);
    }

    @Override
    public boolean isClassified() {
        return true;
    }

    @Override
    public void classify() {
    }

    @Override
    public boolean isRealised() throws OWLReasonerException {
        return true;
    }

    @Override
    public void realise() throws OWLReasonerException {
    }

    @Override
    public boolean isDefined(OWLClass cls) throws OWLReasonerException {
        return true;
    }

    @Override
    public boolean isDefined(OWLObjectProperty prop) throws OWLReasonerException {
        return true;
    }

    @Override
    public boolean isDefined(OWLDataProperty prop) throws OWLReasonerException {
        return true;
    }

    @Override
    public boolean isDefined(OWLIndividual ind) throws OWLReasonerException {
        return true;
    }

    private void setOntologies() {
        if (this.root == null) {
            this.root = this.manager.getOWLDataFactory().getOWLThing();
        }
        this.rebuildImplicitRoots();
    }

    @Override
    public void loadOntologies(Set<OWLOntology> ontologies) {
        this.ontologies.addAll(ontologies);
        this.setOntologies();
    }

    @Override
    public Set<OWLOntology> getLoadedOntologies() {
        return Collections.unmodifiableSet(this.ontologies);
    }

    @Override
    public void unloadOntologies(Set<OWLOntology> ontologies) {
        this.ontologies.removeAll(ontologies);
        this.setOntologies();
    }

    @Override
    public void clearOntologies() {
        this.ontologies.clear();
        this.setOntologies();
    }

    private void rebuildImplicitRoots() {
        this.checker = new SimpleRootClassChecker(this.ontologies);
        this.implicitRoots.clear();
        HashSet<OWLClass> checkedClasses = new HashSet<OWLClass>();
        for (OWLOntology ont : this.ontologies) {
            Set<OWLClass> ref = ont.getReferencedClasses();
            for (OWLClass cls : ref) {
                if (checkedClasses.contains(cls)) continue;
                if (this.isImplicitSubClassOfThing(cls)) {
                    this.implicitRoots.add(cls);
                }
                checkedClasses.add(cls);
            }
        }
    }

    private boolean isImplicitSubClassOfThing(OWLClass cls) {
        Set<OWLClass> ancestors;
        boolean isRoot = this.checker.isRootClass(cls);
        if (!isRoot && (ancestors = this.getAncestors(cls)).contains(cls)) {
            for (OWLClass anc : ancestors) {
                if (!this.getAncestors(anc).contains(cls)) continue;
                this.implicitRoots.add(anc);
            }
            return true;
        }
        return isRoot;
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            for (OWLEntity entity : ((OWLAxiomChange)oWLOntologyChange).getEntities()) {
                if (!(entity instanceof OWLClass)) continue;
                this.updateImplicitRoots((OWLClass)entity);
            }
        }
    }

    private void updateImplicitRoots(OWLClass cls) {
        if (!this.containsReference(cls)) {
            this.implicitRoots.remove(cls);
            return;
        }
        if (this.isImplicitSubClassOfThing(cls)) {
            this.implicitRoots.add(cls);
        } else {
            this.implicitRoots.remove(cls);
        }
    }

    private Set<OWLClass> getChildren(OWLClass object) {
        Set<Object> result;
        if (object.equals(this.root)) {
            result = new HashSet();
            result.addAll(this.implicitRoots);
            result.addAll(this.extractChildren(object));
            result.remove(object);
        } else {
            result = this.extractChildren(object);
            Iterator<Object> it = result.iterator();
            while (it.hasNext()) {
                OWLClass curChild = (OWLClass)it.next();
                if (!this.getAncestors(object).contains(curChild)) continue;
                it.remove();
            }
        }
        return result;
    }

    private Set<OWLClass> extractChildren(OWLClass parent) {
        this.childClassExtractor.setCurrentParentClass(parent);
        HashSet<OWLClass> result = new HashSet<OWLClass>(this.childClassExtractor.getResult());
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getReferencingAxioms(parent)) {
                this.childClassExtractor.reset();
                if (!ax.isLogicalAxiom()) continue;
                ax.accept(this.childClassExtractor);
                result.addAll(this.childClassExtractor.getResult());
            }
        }
        return result;
    }

    private boolean containsReference(OWLClass object) {
        for (OWLOntology ont : this.ontologies) {
            if (!ont.containsClassReference(object.getURI())) continue;
            return true;
        }
        return false;
    }

    private Set<OWLClass> getParents(OWLClass object) {
        if (object.equals(this.root)) {
            return Collections.emptySet();
        }
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        if (this.implicitRoots.contains(object)) {
            result.add(this.root);
        }
        this.parentClassExtractor.reset();
        this.parentClassExtractor.setCurrentClass(object);
        for (OWLOntology ont : this.ontologies) {
            for (OWLClassAxiom ax : ont.getAxioms(object)) {
                ax.accept(this.parentClassExtractor);
            }
        }
        result.addAll(this.parentClassExtractor.getResult());
        return result;
    }

    private Set<OWLClass> getEquivalents(OWLClass object) {
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLDescription equiv : object.getEquivalentClasses(ont)) {
                if (equiv.isAnonymous()) continue;
                result.add((OWLClass)equiv);
            }
        }
        Set<OWLClass> ancestors = this.getAncestors(object);
        if (ancestors.contains(object)) {
            for (OWLClass cls : ancestors) {
                if (!this.getAncestors(cls).contains(object)) continue;
                result.add(cls);
            }
            result.remove(object);
            result.remove(this.root);
        }
        return result;
    }

    private Set<OWLClass> getAncestors(OWLClass object) {
        HashSet<OWLClass> results = new HashSet<OWLClass>();
        this.getAncestors(results, object);
        return results;
    }

    private void getAncestors(Set<OWLClass> results, OWLClass object) {
        for (OWLClass parent : this.getParents(object)) {
            if (results.contains(parent)) continue;
            results.add(parent);
            this.getAncestors(results, parent);
        }
    }

    private Set<OWLClass> getDescendants(OWLClass object) {
        HashSet<OWLClass> results = new HashSet<OWLClass>();
        this.getDescendants(results, object);
        return results;
    }

    private void getDescendants(Set<OWLClass> results, OWLClass object) {
        for (OWLClass child : this.getChildren(object)) {
            if (results.contains(child)) continue;
            results.add(child);
            this.getDescendants(results, child);
        }
    }

    @Override
    public boolean isSubClassOf(OWLDescription clsC, OWLDescription clsD) {
        if (clsC.isAnonymous() || clsD.isAnonymous()) {
            return false;
        }
        return this.getChildren((OWLClass)clsD).contains(clsC);
    }

    @Override
    public boolean isEquivalentClass(OWLDescription clsC, OWLDescription clsD) {
        if (clsC.isAnonymous() || clsD.isAnonymous()) {
            return false;
        }
        return this.getEquivalents((OWLClass)clsC).contains(clsD);
    }

    @Override
    public boolean isSatisfiable(OWLDescription clsC) {
        return true;
    }

    @Override
    public Set<OWLClass> getInconsistentClasses() {
        return Collections.emptySet();
    }

    @Override
    public Set<Set<OWLClass>> getSuperClasses(OWLDescription clsC) {
        if (clsC.isAnonymous()) {
            return Collections.emptySet();
        }
        return this.toSetOfSets(this.getParents((OWLClass)clsC));
    }

    @Override
    public Set<Set<OWLClass>> getAncestorClasses(OWLDescription clsC) {
        if (clsC.isAnonymous()) {
            return Collections.emptySet();
        }
        return this.toSetOfSets(this.getAncestors((OWLClass)clsC));
    }

    @Override
    public Set<Set<OWLClass>> getSubClasses(OWLDescription clsC) {
        if (clsC.isAnonymous()) {
            return Collections.emptySet();
        }
        return this.toSetOfSets(this.getChildren((OWLClass)clsC));
    }

    @Override
    public Set<Set<OWLClass>> getDescendantClasses(OWLDescription clsC) {
        if (clsC.isAnonymous()) {
            return Collections.emptySet();
        }
        return this.toSetOfSets(this.getDescendants((OWLClass)clsC));
    }

    @Override
    public Set<OWLClass> getEquivalentClasses(OWLDescription clsC) {
        if (clsC.isAnonymous()) {
            return Collections.emptySet();
        }
        return this.getEquivalents((OWLClass)clsC);
    }

    private Set<Set<OWLClass>> toSetOfSets(Set<OWLClass> clses) {
        HashSet<Set<OWLClass>> result = new HashSet<Set<OWLClass>>();
        for (OWLClass cls : clses) {
            HashSet<OWLClass> equivSet = new HashSet<OWLClass>();
            equivSet.add(cls);
            equivSet.addAll(this.getEquivalents(cls));
            result.add(equivSet);
        }
        return result;
    }

    private class ChildClassExtractor
    extends OWLAxiomVisitorAdapter {
        private NamedClassChecker checker;
        private NamedClassExtractor namedClassExtractor;
        private OWLClass currentParentClass;
        private Set<OWLClass> results;

        private ChildClassExtractor() {
            this.checker = new NamedClassChecker();
            this.namedClassExtractor = new NamedClassExtractor();
            this.results = new HashSet<OWLClass>();
        }

        public void reset() {
            this.results.clear();
            this.namedClassExtractor.reset();
        }

        public void setCurrentParentClass(OWLClass currentParentClass) {
            this.currentParentClass = currentParentClass;
            this.checker.setSearchClass(currentParentClass);
            this.reset();
        }

        public Set<OWLClass> getResult() {
            return this.results;
        }

        @Override
        public void visit(OWLSubClassAxiom axiom) {
            this.checker.reset();
            axiom.getSuperClass().accept(this.checker);
            if (this.checker.containsSearchClass() && !axiom.getSubClass().isAnonymous()) {
                this.results.add((OWLClass)axiom.getSubClass());
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            Set<OWLDescription> equivalentClasses = axiom.getDescriptions();
            HashSet<OWLDescription> candidateDescriptions = new HashSet<OWLDescription>();
            this.checker.reset();
            boolean found = false;
            for (OWLDescription equivalentClass : equivalentClasses) {
                equivalentClass.accept(this.checker);
                if (!this.checker.containsSearchClass()) {
                    candidateDescriptions.add(equivalentClass);
                    continue;
                }
                found = true;
            }
            if (!found) {
                return;
            }
            this.namedClassExtractor.reset();
            for (OWLDescription desc : candidateDescriptions) {
                desc.accept(this.namedClassExtractor);
            }
            this.results.addAll(this.namedClassExtractor.getResult());
        }
    }

    private class NamedClassChecker
    extends OWLDescriptionVisitorAdapter {
        private boolean found;
        private OWLClass searchClass;

        private NamedClassChecker() {
        }

        public void setSearchClass(OWLClass searchClass) {
            this.searchClass = searchClass;
            this.reset();
        }

        public void reset() {
            this.found = false;
        }

        public boolean containsSearchClass() {
            return this.found;
        }

        @Override
        public void visit(OWLClass desc) {
            if (desc.equals(this.searchClass)) {
                this.found = true;
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                op.accept(this);
                if (!this.found) continue;
                break;
            }
        }
    }

    private class NamedClassExtractor
    extends OWLDescriptionVisitorAdapter {
        Set<OWLClass> result = new HashSet<OWLClass>();

        private NamedClassExtractor() {
        }

        public void reset() {
            this.result.clear();
        }

        public Set<OWLClass> getResult() {
            return this.result;
        }

        @Override
        public void visit(OWLClass desc) {
            this.result.add(desc);
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                op.accept(this);
            }
        }
    }

    private class ParentClassExtractor
    extends OWLAxiomVisitorAdapter {
        private NamedClassExtractor extractor;
        private OWLClass current;

        private ParentClassExtractor() {
            this.extractor = new NamedClassExtractor();
        }

        public void setCurrentClass(OWLClass current) {
            this.current = current;
        }

        public void reset() {
            this.extractor.reset();
        }

        public Set<OWLClass> getResult() {
            return this.extractor.getResult();
        }

        @Override
        public void visit(OWLSubClassAxiom axiom) {
            axiom.getSuperClass().accept(this.extractor);
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                if (desc.equals(this.current)) continue;
                desc.accept(this.extractor);
            }
        }
    }
}

