/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.vocab;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public enum DublinCoreVocabulary {
    CONTRIBUTOR("contributor"),
    COVERAGE("coverage"),
    CREATOR("creator"),
    DATE("date"),
    DESCRIPTION("description"),
    FORMAT("format"),
    IDENTIFIER("identifier"),
    LANGUAGE("language"),
    PUBLISHER("publisher"),
    RELATION("relation"),
    RIGHTS("rights"),
    SOURCE("source"),
    SUBJECT("subject"),
    TITLE("title"),
    TYPE("type");

    private String shortName;
    private String qname;
    private URI uri;
    public static final String NAME_SPACE = "http://purl.org/dc/elements/1.1/";
    public static Set<URI> ALL_URIS;

    private DublinCoreVocabulary(String name) {
        this.shortName = name;
        this.qname = "dc:" + name;
        this.uri = URI.create(NAME_SPACE + name);
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getQName() {
        return this.qname;
    }

    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    static {
        ALL_URIS = new HashSet<URI>();
        for (DublinCoreVocabulary v : DublinCoreVocabulary.values()) {
            ALL_URIS.add(v.getURI());
        }
    }
}

