/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.vocab;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.vocab.Namespaces;

public enum OWLRestrictedDataRangeFacetVocabulary {
    LENGTH(Namespaces.XSD, "length", "length"),
    MIN_LENGTH(Namespaces.XSD, "minLength", "minLength"),
    MAX_LENGTH(Namespaces.XSD, "maxLength", "maxLength"),
    PATTERN(Namespaces.XSD, "pattern", "pattern"),
    MIN_INCLUSIVE(Namespaces.XSD, "minInclusive", ">="),
    MIN_EXCLUSIVE(Namespaces.XSD, "minExclusive", ">"),
    MAX_INCLUSIVE(Namespaces.XSD, "maxInclusive", "<="),
    MAX_EXCLUSIVE(Namespaces.XSD, "maxExclusive", "<"),
    TOTAL_DIGITS(Namespaces.XSD, "totalDigits", "totalDigits"),
    FRACTION_DIGITS(Namespaces.XSD, "fractionDigits", "fractionDigits"),
    LANG_PATTERN(Namespaces.RDF, "langPattern", "langPattern");

    public static final Set<URI> FACET_URIS;
    private URI uri;
    private String shortName;
    private String symbolicForm;

    private OWLRestrictedDataRangeFacetVocabulary(Namespaces ns, String shortName, String symbolicForm) {
        this.uri = URI.create((Object)((Object)ns) + shortName);
        this.shortName = shortName;
        this.symbolicForm = symbolicForm;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getSymbolicForm() {
        return this.symbolicForm;
    }

    public String toString() {
        return this.shortName;
    }

    public static Set<URI> getFacetURIs() {
        return FACET_URIS;
    }

    public static OWLRestrictedDataRangeFacetVocabulary getFacet(URI uri) {
        for (OWLRestrictedDataRangeFacetVocabulary vocabulary : OWLRestrictedDataRangeFacetVocabulary.values()) {
            if (!vocabulary.getURI().equals(uri)) continue;
            return vocabulary;
        }
        return null;
    }

    public static OWLRestrictedDataRangeFacetVocabulary getFacetByShortName(String shortName) {
        for (OWLRestrictedDataRangeFacetVocabulary vocabulary : OWLRestrictedDataRangeFacetVocabulary.values()) {
            if (!vocabulary.getShortName().equals(shortName)) continue;
            return vocabulary;
        }
        return null;
    }

    public static OWLRestrictedDataRangeFacetVocabulary getFacetBySymbolicName(String symbolicName) {
        for (OWLRestrictedDataRangeFacetVocabulary vocabulary : OWLRestrictedDataRangeFacetVocabulary.values()) {
            if (!vocabulary.getSymbolicForm().equals(symbolicName)) continue;
            return vocabulary;
        }
        return null;
    }

    public static Set<String> getFacets() {
        HashSet<String> result = new HashSet<String>();
        for (OWLRestrictedDataRangeFacetVocabulary v : OWLRestrictedDataRangeFacetVocabulary.values()) {
            result.add(v.getSymbolicForm());
        }
        return result;
    }

    static {
        HashSet<URI> uris = new HashSet<URI>();
        for (OWLRestrictedDataRangeFacetVocabulary v : OWLRestrictedDataRangeFacetVocabulary.values()) {
            uris.add(v.getURI());
        }
        FACET_URIS = Collections.unmodifiableSet(uris);
    }
}

