/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.reasonerfactory.factpp;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.reasonerfactory.OWLReasonerSetupException;
import org.semanticweb.reasonerfactory.factpp.FaCTNativeLibraryNotFoundException;

public class FaCTPlusPlusReasonerFactory
implements OWLReasonerFactory {
    private Constructor factPPConstructor;
    private Method setSynchronisingMethod;

    public FaCTPlusPlusReasonerFactory() {
        try {
            Class<?> faCTPPClass = Class.forName("uk.ac.manchester.cs.factplusplus.owlapi.Reasoner");
            this.factPPConstructor = faCTPPClass.getConstructor(OWLOntologyManager.class);
            this.setSynchronisingMethod = faCTPPClass.getMethod("setSychroniseOnlyOnClassify", Boolean.TYPE);
        }
        catch (ClassNotFoundException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }

    @Override
    public String getReasonerName() {
        return "FaCT++";
    }

    @Override
    public OWLReasoner createReasoner(OWLOntologyManager manager) {
        try {
            OWLReasoner reasoner = (OWLReasoner)this.factPPConstructor.newInstance(manager);
            this.setSynchronisingMethod.invoke((Object)reasoner, Boolean.FALSE);
            return reasoner;
        }
        catch (InstantiationException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new FaCTNativeLibraryNotFoundException();
        }
    }
}

