/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.reasonerfactory.pellet;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.reasonerfactory.OWLReasonerSetupException;

public class PelletReasonerFactory
implements OWLReasonerFactory {
    public static final String CLASS_NAME = "org.mindswap.pellet.owlapi.Reasoner";
    private Constructor reasonerConstructor;

    public PelletReasonerFactory() {
        try {
            Class<?> pelletReasonerClass = Class.forName(CLASS_NAME);
            this.reasonerConstructor = pelletReasonerClass.getConstructor(OWLOntologyManager.class);
            this.setTracingEnabled(false);
            this.setUseConsoleProgressMonitor();
        }
        catch (ClassNotFoundException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }

    public void setTracingEnabled(boolean b) {
        try {
            Class<?> pelletOptionsClass = Class.forName("org.mindswap.pellet.PelletOptions");
            Field tracingField = pelletOptionsClass.getField("USE_TRACING");
            tracingField.set(pelletOptionsClass, b);
        }
        catch (ClassNotFoundException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }

    public void setUseConsoleProgressMonitor() {
        try {
            Class<?> pelletOptionsClass = Class.forName("org.mindswap.pellet.PelletOptions");
            Field tracingField = pelletOptionsClass.getField("USE_CLASSIFICATION_MONITOR");
            Class<?> monitorType = Class.forName(pelletOptionsClass.getName() + "$MonitorType");
            Field monitorTypeNoneField = monitorType.getField("NONE");
            tracingField.set(pelletOptionsClass, monitorTypeNoneField.get(monitorType));
        }
        catch (ClassNotFoundException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }

    public void turnOffLogging() {
        this.setABoxLogging(Level.OFF);
        this.setTaxonomyLogging(Level.OFF);
        this.setKnowledgeBaseLogging(Level.OFF);
        this.setRBoxLogging(Level.OFF);
        this.setPelletVisitorLogging(Level.OFF);
    }

    public void setPelletVisitorLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.owlapi.PelletVisitor", level);
    }

    public void setRBoxLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.RBox", level);
    }

    public void setKnowledgeBaseLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.KnowledgeBase", level);
    }

    public void setTaxonomyLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.taxonomy.Taxonomy", level);
    }

    public void setABoxLogging(Level level) {
        this.setLoggingLevel("org.mindswap.pellet.ABox", level);
    }

    public void setLoggingLevel(String className, Level level) {
        try {
            Class<?> cls = Class.forName(className);
            Class<?> loggerCls = Class.forName(Logger.class.getName());
            Field logField = cls.getField("log");
            Logger logger = (Logger)loggerCls.cast(logField.get(cls));
            logger.setLevel(level);
        }
        catch (ClassNotFoundException e) {
            PelletReasonerFactory.printLoggingErrorMessage(e);
        }
        catch (NoSuchFieldException e) {
            PelletReasonerFactory.printLoggingErrorMessage(e);
        }
        catch (IllegalAccessException e) {
            PelletReasonerFactory.printLoggingErrorMessage(e);
        }
        catch (ClassCastException e) {
            PelletReasonerFactory.printLoggingErrorMessage(e);
        }
    }

    private static void printLoggingErrorMessage(Exception e) {
        System.err.println("Could not turn off logging: " + e.getMessage());
        System.err.println("Upgrade to Pellet 2.0.0 or higher");
    }

    @Override
    public String getReasonerName() {
        return "Pellet";
    }

    @Override
    public OWLReasoner createReasoner(OWLOntologyManager manager) {
        try {
            return (OWLReasoner)this.reasonerConstructor.newInstance(manager);
        }
        catch (InstantiationException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new OWLReasonerSetupException(this, (Throwable)e);
        }
    }
}

