/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.bhig.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.manchester.cs.bhig.util.NodeRenderer;
import uk.ac.manchester.cs.bhig.util.Tree;

public class MutableTree<N>
implements Tree<N> {
    private N userObject;
    private MutableTree<N> parent;
    private List<MutableTree<N>> children;
    private Map<Tree<N>, Object> child2EdgeMap;
    private NodeRenderer<N> toStringRenderer;

    public MutableTree(N userObject) {
        this.userObject = userObject;
        this.children = new ArrayList<MutableTree<N>>();
        this.child2EdgeMap = new HashMap<Tree<N>, Object>();
        this.toStringRenderer = new NodeRenderer<N>(){

            @Override
            public String render(Tree<N> object) {
                return object.toString();
            }
        };
    }

    @Override
    public N getUserObject() {
        return this.userObject;
    }

    public void setParent(MutableTree<N> parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        this.parent.children.add(this);
    }

    public void addChild(MutableTree<N> child) {
        this.children.add(child);
        child.parent = this;
    }

    public void addChild(MutableTree<N> child, Object edge) {
        this.addChild(child);
        this.child2EdgeMap.put(child, edge);
    }

    public void removeChild(MutableTree<N> child) {
        this.children.remove(child);
        child.parent = null;
    }

    @Override
    public Object getEdge(Tree<N> child) {
        return this.child2EdgeMap.get(child);
    }

    @Override
    public void sortChildren(Comparator<Tree<N>> comparator) {
        Collections.sort(this.children, comparator);
    }

    public void clearChildren() {
        for (MutableTree<N> child : new ArrayList<MutableTree<N>>(this.children)) {
            this.removeChild(child);
        }
    }

    @Override
    public Tree<N> getParent() {
        return this.parent;
    }

    @Override
    public List<Tree<N>> getChildren() {
        return new ArrayList<Tree<N>>(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public Tree<N> getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public List<Tree<N>> getPathToRoot() {
        ArrayList<Tree<N>> path = new ArrayList<Tree<N>>();
        path.add(0, this);
        for (Tree<N> par = this.parent; par != null; par = par.getParent()) {
            path.add(0, par);
        }
        return path;
    }

    @Override
    public List<N> getUserObjectPathToRoot() {
        ArrayList path = new ArrayList();
        path.add(0, this.getUserObject());
        for (Tree<N> par = this.parent; par != null; par = par.getParent()) {
            path.add(0, par.getUserObject());
        }
        return path;
    }

    @Override
    public Set<N> getUserObjectClosure() {
        HashSet objects = new HashSet();
        this.getUserObjectClosure(this, objects);
        return objects;
    }

    private void getUserObjectClosure(Tree<N> tree, Set<N> bin) {
        bin.add(tree.getUserObject());
        for (Tree<N> child : tree.getChildren()) {
            this.getUserObjectClosure(child, bin);
        }
    }

    @Override
    public void dump(PrintWriter writer) {
        this.dump(writer, 0);
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        int depth = this.getPathToRoot().size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth + indent; ++i) {
            sb.append("\t");
        }
        writer.print(sb.toString());
        String ren = this.toStringRenderer.render(this);
        ren = ren.replace("\n", "\n" + sb);
        writer.println(ren);
        for (Tree<N> child : this.getChildren()) {
            Object edge = this.getEdge(child);
            if (edge != null) {
                writer.print(sb.toString());
                writer.print("--- ");
                writer.print(edge);
                writer.print(" ---\n\n");
            }
            child.dump(writer, indent);
        }
        writer.flush();
    }

    @Override
    public void setNodeRenderer(NodeRenderer<N> renderer) {
        this.toStringRenderer = renderer;
        for (MutableTree<N> child : this.children) {
            child.setNodeRenderer(this.toStringRenderer);
        }
    }

    @Override
    public List<N> fillDepthFirst() {
        ArrayList results = new ArrayList();
        this.fillDepthFirst(this, results);
        return results;
    }

    private void fillDepthFirst(Tree<N> tree, List<N> bin) {
        bin.add(tree.getUserObject());
        for (Tree<N> child : tree.getChildren()) {
            this.fillDepthFirst(child, bin);
        }
    }

    public void replace(MutableTree<N> tree) {
        this.parent.children.remove(this);
        this.parent.children.add(tree);
        this.parent = null;
        tree.children.clear();
        tree.children.addAll(this.children);
        this.children.clear();
    }

    public String toString() {
        if (this.userObject != null) {
            return this.userObject.toString();
        }
        return "";
    }

    public int getSize() {
        return this.getUserObjectClosure().size();
    }

    public int getMaxDepth() {
        return this.getMaxDepth(this);
    }

    private int getMaxDepth(Tree<N> tree) {
        int maxChildDepth = tree.getPathToRoot().size();
        for (Tree<N> child : tree.getChildren()) {
            int childDepth = this.getMaxDepth(child);
            if (childDepth <= maxChildDepth) continue;
            maxChildDepth = childDepth;
        }
        return maxChildDepth;
    }

    public static void main(String[] args) {
        MutableTree<String> tree = new MutableTree<String>("1");
        for (int i = 0; i < 3; ++i) {
            MutableTree<String> tree1 = new MutableTree<String>("1." + i);
            tree.addChild(tree1);
            for (int j = 0; j < 2; ++j) {
                tree1.addChild(new MutableTree<String>("2." + i + "." + j));
            }
        }
        System.out.println(tree.getSize());
        System.out.println(tree.getMaxDepth());
    }
}

