/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;

public class ImplUtils {
    public static Set<OWLAnnotationAxiom> getAnnotationAxioms(OWLEntity entity, Set<OWLOntology> ontologies) {
        HashSet<OWLAnnotationAxiom> result = new HashSet<OWLAnnotationAxiom>();
        for (OWLOntology ont : ontologies) {
            result.addAll(ont.getEntityAnnotationAxioms(entity));
        }
        return result;
    }

    public static Set<OWLAnnotation> getAnnotations(OWLEntity entity, Set<OWLOntology> ontologies) {
        HashSet<OWLAnnotation> result = new HashSet<OWLAnnotation>();
        for (OWLAnnotationAxiom ax : ImplUtils.getAnnotationAxioms(entity, ontologies)) {
            result.add(ax.getAnnotation());
        }
        return result;
    }

    public static Set<OWLAnnotation> getAnnotations(OWLEntity entity, URI annotationURI, Set<OWLOntology> ontologies) {
        HashSet<OWLAnnotation> result = new HashSet<OWLAnnotation>();
        for (OWLAnnotationAxiom ax : ImplUtils.getAnnotationAxioms(entity, ontologies)) {
            if (!ax.getAnnotation().getAnnotationURI().equals(annotationURI)) continue;
            result.add(ax.getAnnotation());
        }
        return result;
    }
}

