/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import uk.ac.manchester.cs.owl.OWLNaryClassAxiomImpl;

public class OWLEquivalentClassesAxiomImpl
extends OWLNaryClassAxiomImpl
implements OWLEquivalentClassesAxiom {
    private Set<OWLClass> namedClasses = null;

    public OWLEquivalentClassesAxiomImpl(OWLDataFactory dataFactory, Set<? extends OWLDescription> descriptions) {
        super(dataFactory, descriptions);
    }

    @Override
    public boolean containsNamedEquivalentClass() {
        return !this.getNamedClasses().isEmpty();
    }

    @Override
    public boolean containsOWLNothing() {
        for (OWLDescription desc : this.getDescriptions()) {
            if (!desc.isOWLNothing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsOWLThing() {
        for (OWLDescription desc : this.getDescriptions()) {
            if (!desc.isOWLThing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLClass> getNamedClasses() {
        if (this.namedClasses == null) {
            HashSet<OWLClass> clses = new HashSet<OWLClass>(1);
            for (OWLDescription desc : this.getDescriptions()) {
                if (desc.isAnonymous() || desc.isOWLNothing() || desc.isOWLThing()) continue;
                clses.add(desc.asOWLClass());
            }
            this.namedClasses = Collections.unmodifiableSet(clses);
        }
        return this.namedClasses;
    }

    @Override
    public Set<OWLSubClassAxiom> asSubClassAxioms() {
        HashSet<OWLSubClassAxiom> result = new HashSet<OWLSubClassAxiom>();
        for (OWLDescription descA : this.getDescriptions()) {
            for (OWLDescription descB : this.getDescriptions()) {
                if (descA.equals(descB)) continue;
                result.add(this.getOWLDataFactory().getOWLSubClassAxiom(descA, descB));
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return obj instanceof OWLEquivalentClassesAxiom;
        }
        return false;
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.EQUIVALENT_CLASSES;
    }
}

