/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLNaryPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.util.ObjectPropertySimplifier;
import uk.ac.manchester.cs.owl.OWLPropertyExpressionImpl;

public abstract class OWLObjectPropertyExpressionImpl
extends OWLPropertyExpressionImpl<OWLObjectPropertyExpression, OWLDescription>
implements OWLObjectPropertyExpression {
    private OWLObjectPropertyExpression simplestForm;
    private OWLObjectPropertyExpression inverse;

    public OWLObjectPropertyExpressionImpl(OWLDataFactory dataFactory) {
        super(dataFactory);
    }

    @Override
    protected Set<? extends OWLPropertyDomainAxiom> getDomainAxioms(OWLOntology ontology) {
        return ontology.getObjectPropertyDomainAxioms(this);
    }

    @Override
    public boolean isFunctional(OWLOntology ontology) {
        return ontology.getFunctionalObjectPropertyAxiom(this) != null;
    }

    @Override
    public boolean isFunctional(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isFunctional(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInverseFunctional(OWLOntology ontology) {
        return ontology.getInverseFunctionalObjectPropertyAxiom(this) != null;
    }

    @Override
    public boolean isInverseFunctional(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isInverseFunctional(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSymmetric(OWLOntology ontology) {
        return ontology.getSymmetricObjectPropertyAxiom(this) != null;
    }

    @Override
    public boolean isSymmetric(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isSymmetric(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAntiSymmetric(OWLOntology ontology) {
        return ontology.getAntiSymmetricObjectPropertyAxiom(this) != null;
    }

    @Override
    public boolean isAntiSymmetric(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isAntiSymmetric(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAsymmetric(OWLOntology ontology) {
        return ontology.getAntiSymmetricObjectPropertyAxiom(this) != null;
    }

    @Override
    public boolean isAsymmetric(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isAntiSymmetric(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReflexive(OWLOntology ontology) {
        return ontology.getReflexiveObjectPropertyAxiom(this) != null;
    }

    @Override
    public boolean isReflexive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isReflexive(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIrreflexive(OWLOntology ontology) {
        return ontology.getIrreflexiveObjectPropertyAxiom(this) != null;
    }

    @Override
    public boolean isIrreflexive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isIrreflexive(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransitive(OWLOntology ontology) {
        return ontology.getTransitiveObjectPropertyAxiom(this) != null;
    }

    @Override
    public boolean isTransitive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isTransitive(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<? extends OWLPropertyRangeAxiom<OWLObjectPropertyExpression, OWLDescription>> getRangeAxioms(OWLOntology ontology) {
        return ontology.getObjectPropertyRangeAxioms(this);
    }

    @Override
    protected Set<? extends OWLSubPropertyAxiom<OWLObjectPropertyExpression>> getSubPropertyAxioms(OWLOntology ontology) {
        return ontology.getObjectSubPropertyAxiomsForLHS(this);
    }

    @Override
    protected Set<? extends OWLNaryPropertyAxiom<OWLObjectPropertyExpression>> getEquivalentPropertiesAxioms(OWLOntology ontology) {
        return ontology.getEquivalentObjectPropertiesAxioms(this);
    }

    @Override
    protected Set<? extends OWLNaryPropertyAxiom<OWLObjectPropertyExpression>> getDisjointPropertiesAxioms(OWLOntology ontology) {
        return ontology.getDisjointObjectPropertiesAxiom(this);
    }

    @Override
    public Set<OWLObjectPropertyExpression> getInverses(OWLOntology ontology) {
        TreeSet<OWLObjectPropertyExpression> result = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLInverseObjectPropertiesAxiom ax : ontology.getInverseObjectPropertyAxioms(this)) {
            result.addAll(ax.getProperties());
        }
        result.remove(this);
        return result;
    }

    @Override
    public Set<OWLObjectPropertyExpression> getInverses(Set<OWLOntology> ontologies) {
        TreeSet<OWLObjectPropertyExpression> result = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getInverses(ont));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLObjectPropertyExpression;
    }

    @Override
    public OWLObjectPropertyExpression getSimplified() {
        if (this.simplestForm == null) {
            ObjectPropertySimplifier simplifier = new ObjectPropertySimplifier(this.getOWLDataFactory());
            this.simplestForm = simplifier.getSimplified(this);
        }
        return this.simplestForm;
    }

    @Override
    public OWLObjectPropertyExpression getInverseProperty() {
        if (this.inverse == null) {
            this.inverse = this.getOWLDataFactory().getOWLObjectPropertyInverse(this);
        }
        return this.inverse;
    }

    @Override
    public OWLObjectProperty getNamedProperty() {
        OWLObjectPropertyExpression simp = this.getSimplified();
        if (simp.isAnonymous()) {
            return ((OWLObjectPropertyInverse)simp).getInverse().asOWLObjectProperty();
        }
        return simp.asOWLObjectProperty();
    }
}

