/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataVisitor;
import org.semanticweb.owl.model.OWLDataVisitorEx;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import uk.ac.manchester.cs.owl.OWLConstantImpl;

public class OWLTypedConstantImpl
extends OWLConstantImpl
implements OWLTypedConstant {
    private OWLDataType dataType;

    public OWLTypedConstantImpl(OWLDataFactory dataFactory, String literal, OWLDataType dataType) {
        super(dataFactory, literal);
        this.dataType = dataType;
    }

    @Override
    public OWLDataType getDataType() {
        return this.dataType;
    }

    @Override
    public OWLTypedConstant asOWLTypedConstant() {
        return this;
    }

    @Override
    public OWLUntypedConstant asOWLUntypedConstant() {
        throw new OWLRuntimeException("Not an untyped constant!");
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLTypedConstant)) {
                return false;
            }
            return ((OWLTypedConstant)obj).getDataType().equals(this.dataType);
        }
        return false;
    }

    @Override
    public boolean isTyped() {
        return true;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLTypedConstant other = (OWLTypedConstant)object;
        int diff = this.dataType.compareTo(other.getDataType());
        if (diff != 0) {
            return diff;
        }
        return this.getLiteral().compareTo(other.getLiteral());
    }
}

