/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataVisitor;
import org.semanticweb.owl.model.OWLDataVisitorEx;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import uk.ac.manchester.cs.owl.OWLConstantImpl;

public class OWLUntypedConstantImpl
extends OWLConstantImpl
implements OWLUntypedConstant {
    private String lang;

    public OWLUntypedConstantImpl(OWLDataFactory dataFactory, String literal, String lang) {
        super(dataFactory, literal);
        this.lang = lang;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public boolean hasLang() {
        return this.lang != null;
    }

    @Override
    public boolean hasLang(String lang) {
        if (lang == null) {
            return false;
        }
        if (this.lang == null) {
            return false;
        }
        return this.lang.equals(lang);
    }

    @Override
    public boolean isTyped() {
        return false;
    }

    @Override
    public OWLTypedConstant asOWLTypedConstant() {
        throw new OWLRuntimeException("Not a typed constant!");
    }

    @Override
    public OWLUntypedConstant asOWLUntypedConstant() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof OWLUntypedConstant) {
            String otherLang = ((OWLUntypedConstant)obj).getLang();
            if (otherLang != null) {
                return otherLang.equals(this.lang);
            }
            return this.lang == null;
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLUntypedConstant other = (OWLUntypedConstant)object;
        if (this.hasLang()) {
            if (other.hasLang()) {
                int diff = this.getLang().compareTo(other.getLang());
                if (diff != 0) {
                    return diff;
                }
            } else {
                return 1;
            }
        }
        return this.getLiteral().compareTo(other.getLiteral());
    }
}

