/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomObject;
import org.semanticweb.owl.model.SWRLAtomVariable;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLObjectVisitor;
import org.semanticweb.owl.model.SWRLObjectVisitorEx;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.util.SWRLVariableExtractor;
import uk.ac.manchester.cs.owl.OWLAxiomImpl;

public class SWRLRuleImpl
extends OWLAxiomImpl
implements SWRLRule {
    private URI uri;
    private Set<SWRLAtom> consequent;
    private Set<SWRLAtom> antecedent;
    private Set<SWRLAtomVariable> variables;
    private Set<SWRLAtomDVariable> dVariables;
    private Set<SWRLAtomIVariable> iVariables;
    private boolean anon;
    private Boolean containsAnonymousDescriptions = null;
    private Set<OWLDescription> classAtomsPredicates;

    public SWRLRuleImpl(OWLDataFactory dataFactory, URI uri, Set<? extends SWRLAtom> antecedent, Set<? extends SWRLAtom> consequent) {
        super(dataFactory);
        this.uri = uri;
        this.anon = false;
        this.consequent = new TreeSet<SWRLAtom>(consequent);
        this.antecedent = new TreeSet<SWRLAtom>(antecedent);
    }

    public SWRLRuleImpl(OWLDataFactory dataFactory, boolean anon, URI uri, Set<? extends SWRLAtom> antecedent, Set<? extends SWRLAtom> consequent) {
        super(dataFactory);
        this.anon = anon;
        this.uri = uri;
        this.antecedent = new TreeSet<SWRLAtom>(antecedent);
        this.consequent = new TreeSet<SWRLAtom>(consequent);
    }

    public SWRLRuleImpl(OWLDataFactory dataFactory, Set<? extends SWRLAtom> antecedent, Set<? extends SWRLAtom> consequent) {
        this(dataFactory, true, URI.create("http://www.semanticweb.org/swrl#" + System.nanoTime()), antecedent, consequent);
    }

    @Override
    public Set<SWRLAtomVariable> getVariables() {
        if (this.variables == null) {
            HashSet<SWRLAtomObject> vars = new HashSet<SWRLAtomObject>();
            SWRLVariableExtractor extractor = new SWRLVariableExtractor();
            this.accept(extractor);
            vars.addAll(extractor.getIVariables());
            vars.addAll(extractor.getDVariables());
            this.variables = new HashSet<SWRLAtomVariable>(vars);
        }
        return this.variables;
    }

    @Override
    public Set<SWRLAtomDVariable> getDVariables() {
        if (this.dVariables == null) {
            HashSet<SWRLAtomDVariable> vars = new HashSet<SWRLAtomDVariable>();
            SWRLVariableExtractor extractor = new SWRLVariableExtractor();
            this.accept(extractor);
            vars.addAll(extractor.getDVariables());
            this.dVariables = new HashSet<SWRLAtomDVariable>(vars);
        }
        return this.dVariables;
    }

    @Override
    public Set<SWRLAtomIVariable> getIVariables() {
        if (this.iVariables == null) {
            HashSet<SWRLAtomIVariable> vars = new HashSet<SWRLAtomIVariable>();
            SWRLVariableExtractor extractor = new SWRLVariableExtractor();
            this.accept(extractor);
            vars.addAll(extractor.getIVariables());
            this.iVariables = new HashSet<SWRLAtomIVariable>(vars);
        }
        return this.iVariables;
    }

    @Override
    public boolean containsAnonymousDescriptions() {
        if (this.containsAnonymousDescriptions == null) {
            for (SWRLAtom atom : this.consequent) {
                if (!(atom instanceof SWRLClassAtom) || !((OWLDescription)((SWRLClassAtom)atom).getPredicate()).isAnonymous()) continue;
                this.containsAnonymousDescriptions = true;
                break;
            }
            if (this.containsAnonymousDescriptions == null) {
                for (SWRLAtom atom : this.antecedent) {
                    if (!(atom instanceof SWRLClassAtom) || !((OWLDescription)((SWRLClassAtom)atom).getPredicate()).isAnonymous()) continue;
                    this.containsAnonymousDescriptions = true;
                    break;
                }
            }
            if (this.containsAnonymousDescriptions == null) {
                this.containsAnonymousDescriptions = false;
            }
        }
        return this.containsAnonymousDescriptions;
    }

    @Override
    public Set<OWLDescription> getClassAtomPredicates() {
        if (this.classAtomsPredicates == null) {
            HashSet predicates = new HashSet();
            for (SWRLAtom atom : this.consequent) {
                if (!(atom instanceof SWRLClassAtom)) continue;
                predicates.add(((SWRLClassAtom)atom).getPredicate());
            }
            for (SWRLAtom atom : this.antecedent) {
                if (!(atom instanceof SWRLClassAtom)) continue;
                predicates.add(((SWRLClassAtom)atom).getPredicate());
            }
            this.classAtomsPredicates = new HashSet<OWLDescription>(predicates);
        }
        return this.classAtomsPredicates;
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(SWRLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(SWRLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isAnonymous() {
        return this.anon;
    }

    @Override
    public Set<SWRLAtom> getBody() {
        return Collections.unmodifiableSet(this.antecedent);
    }

    @Override
    public Set<SWRLAtom> getHead() {
        return Collections.unmodifiableSet(this.consequent);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isLogicalAxiom() {
        return true;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SWRLRule)) {
            return false;
        }
        SWRLRule other = (SWRLRule)obj;
        return (other.getURI().equals(this.uri) || this.isAnonymous() && other.isAnonymous()) && ((Object)other.getBody()).equals(this.antecedent) && ((Object)other.getHead()).equals(this.consequent);
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.SWRL_RULE;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        int diff;
        SWRLRule other = (SWRLRule)object;
        if (!this.isAnonymous()) {
            diff = !other.isAnonymous() ? this.getURI().compareTo(other.getURI()) : -1;
        } else if (!other.isAnonymous()) {
            diff = 1;
        } else {
            diff = SWRLRuleImpl.compareSets(this.getBody(), other.getBody());
            if (diff == 0) {
                diff = SWRLRuleImpl.compareSets(this.getHead(), other.getHead());
            }
        }
        return diff;
    }
}

