/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.inference.dig11;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.manchester.cs.owl.inference.dig11.DIGQueryResponse;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasonerException;

public class DIGQueryResponseImpl
implements DIGQueryResponse {
    private Element element;
    private OWLDataFactory factory;

    public DIGQueryResponseImpl(OWLDataFactory kb) {
        this.factory = kb;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public String getID() {
        return this.element.getAttribute("id");
    }

    @Override
    public Set<Set<OWLClass>> getConceptSets() throws DIGReasonerException {
        NodeList synonymsList = this.element.getElementsByTagName("synonyms");
        HashSet<Set<OWLClass>> conceptSet = new HashSet<Set<OWLClass>>(synonymsList.getLength());
        for (int i = 0; i < synonymsList.getLength(); ++i) {
            NodeList catomList = ((Element)synonymsList.item(i)).getElementsByTagName("catom");
            HashSet<OWLClass> equivalents = new HashSet<OWLClass>();
            for (int j = 0; j < catomList.getLength(); ++j) {
                String name = ((Element)catomList.item(j)).getAttribute("name");
                OWLClass aClass = this.factory.getOWLClass(URI.create(name));
                if (aClass == null) continue;
                equivalents.add(aClass);
            }
            if (((Element)synonymsList.item(i)).getElementsByTagName("top").getLength() != 0) {
                equivalents.add(this.factory.getOWLThing());
            }
            conceptSet.add(equivalents);
        }
        return conceptSet;
    }

    @Override
    public Set<Set<OWLObjectProperty>> getRoleSets() throws DIGReasonerException {
        NodeList synonymsList = this.element.getElementsByTagName("synonyms");
        HashSet<Set<OWLObjectProperty>> conceptSet = new HashSet<Set<OWLObjectProperty>>(synonymsList.getLength());
        for (int i = 0; i < synonymsList.getLength(); ++i) {
            NodeList catomList = ((Element)synonymsList.item(i)).getElementsByTagName("ratom");
            HashSet<OWLObjectProperty> equivalents = new HashSet<OWLObjectProperty>();
            for (int j = 0; j < catomList.getLength(); ++j) {
                String name = ((Element)catomList.item(j)).getAttribute("name");
                OWLObjectProperty prop = this.factory.getOWLObjectProperty(URI.create(name));
                if (prop == null) continue;
                equivalents.add(prop);
            }
            conceptSet.add(equivalents);
        }
        return conceptSet;
    }

    @Override
    public Set<OWLIndividual> getIndividuals() throws DIGReasonerException {
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        NodeList individualElementList = this.element.getElementsByTagName("individual");
        for (int i = 0; i < individualElementList.getLength(); ++i) {
            Element individualElement = (Element)individualElementList.item(i);
            OWLIndividual curInd = this.factory.getOWLIndividual(URI.create(individualElement.getAttribute("name")));
            if (curInd == null) continue;
            individuals.add(curInd);
        }
        return individuals;
    }

    @Override
    public boolean getBoolean() {
        String val = this.element.getTagName();
        boolean b = true;
        if (val.equals("false")) {
            b = false;
        }
        return b;
    }
}

