/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.inference.dig11;

import java.util.Iterator;
import org.semanticweb.owl.model.OWLDataFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.manchester.cs.owl.inference.dig11.DIGQueryResponse;
import uk.ac.manchester.cs.owl.inference.dig11.DIGQueryResponseImpl;

public class DIGQueryResponseIterator
implements Iterator<DIGQueryResponse> {
    private Document doc;
    private int currentElementIndex = 0;
    private NodeList nodeList;
    private boolean elementAvailable = false;
    private DIGQueryResponseImpl interpreter;

    public DIGQueryResponseIterator(Document doc, OWLDataFactory kb) {
        this.doc = doc;
        this.nodeList = this.doc.getDocumentElement().getChildNodes();
        this.currentElementIndex = 0;
        this.interpreter = new DIGQueryResponseImpl(kb);
        this.advanceToNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.elementAvailable;
    }

    protected void advanceToNextElement() {
        int index = this.currentElementIndex;
        this.elementAvailable = true;
        while (this.nodeList.item(index).getNodeType() != 1 || this.nodeList.item(index).getNodeName().equals("error")) {
            if (index == this.nodeList.getLength() - 1) {
                this.elementAvailable = false;
                break;
            }
            ++index;
        }
        this.currentElementIndex = index;
    }

    @Override
    public DIGQueryResponse next() {
        Element element = (Element)this.nodeList.item(this.currentElementIndex);
        ++this.currentElementIndex;
        this.interpreter.setElement(element);
        this.advanceToNextElement();
        return this.interpreter;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

