/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.inference.dig11;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.inference.OWLReasonerAdapter;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.inference.UnsupportedReasonerOperationException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.w3c.dom.Document;
import uk.ac.manchester.cs.owl.inference.dig11.DIGQueryResponse;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasonerException;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasonerPreferences;
import uk.ac.manchester.cs.owl.inference.dig11.DIGRenderer;
import uk.ac.manchester.cs.owl.inference.dig11.DIGTranslator;
import uk.ac.manchester.cs.owl.inference.dig11.DIGTranslatorImpl;
import uk.ac.manchester.cs.owl.inference.dig11.HTTPReasoner;
import uk.ac.manchester.cs.owl.inference.dig11.HTTPReasonerImpl;

public class DIGReasoner
extends OWLReasonerAdapter {
    private static final Logger logger = Logger.getLogger(DIGReasoner.class.getName());
    private HTTPReasoner reasoner;
    private DIGTranslator translator;
    private String kbURI;
    private boolean resynchronize = true;

    public DIGReasoner(OWLOntologyManager owlOntologyManager) throws OWLException {
        super(owlOntologyManager);
        this.reasoner = new HTTPReasonerImpl(owlOntologyManager);
        this.translator = new DIGTranslatorImpl(owlOntologyManager);
        this.reasoner.setReasonerURL(DIGReasonerPreferences.getInstance().getReasonerURL());
    }

    public HTTPReasoner getReasoner() {
        return this.reasoner;
    }

    public DIGTranslator getTranslator() {
        return this.translator;
    }

    public String getKbURI() {
        return this.kbURI;
    }

    @Override
    public boolean isClassified() {
        return !this.resynchronize;
    }

    @Override
    public void classify() throws OWLReasonerException {
        this.synchroniseReasoner();
    }

    @Override
    public boolean isRealised() throws OWLReasonerException {
        return !this.resynchronize;
    }

    @Override
    public void realise() throws OWLReasonerException {
        this.synchroniseReasoner();
    }

    @Override
    public void disposeReasoner() {
        this.releaseCurrentKB();
    }

    @Override
    protected void ontologiesCleared() {
        this.resynchronize = true;
    }

    @Override
    protected void ontologiesChanged() {
        this.resynchronize = true;
    }

    @Override
    protected void handleOntologyChanges(List<OWLOntologyChange> changes) {
        this.resynchronize = true;
    }

    private void releaseCurrentKB() {
        try {
            if (this.kbURI != null) {
                this.reasoner.releaseKnowledgeBase(this.kbURI);
                this.kbURI = null;
            }
        }
        catch (DIGReasonerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReasonerSynchonised() {
        return !this.resynchronize && this.kbURI != null;
    }

    protected void synchroniseReasoner() throws DIGReasonerException {
        if (this.isReasonerSynchonised()) {
            return;
        }
        if (this.kbURI == null) {
            this.kbURI = this.reasoner.createKnowledgeBase();
        }
        logger.info("Synchronizing reasoner...");
        this.translator = new DIGTranslatorImpl(this.getOWLOntologyManager());
        Document doc = this.translator.createTellsDocument(this.kbURI);
        this.reasoner.clearKnowledgeBase(this.kbURI);
        DIGRenderer ren = new DIGRenderer(this.getOWLOntologyManager(), doc, doc.getDocumentElement());
        for (OWLOntology ont : this.getLoadedOntologies()) {
            ont.accept(ren);
        }
        this.reasoner.performRequest(doc);
        logger.info("... synchronized.");
        this.resynchronize = false;
    }

    @Override
    public boolean isDefined(OWLClass cls) throws OWLReasonerException {
        return true;
    }

    @Override
    public boolean isDefined(OWLObjectProperty prop) throws OWLReasonerException {
        return true;
    }

    @Override
    public boolean isDefined(OWLDataProperty prop) throws OWLReasonerException {
        return true;
    }

    @Override
    public boolean isDefined(OWLIndividual ind) throws OWLReasonerException {
        return true;
    }

    protected Document performRequest(Document doc) throws DIGReasonerException {
        this.synchroniseReasoner();
        return this.reasoner.performRequest(doc);
    }

    private Document createAsksDocument() throws DIGReasonerException {
        this.synchroniseReasoner();
        return this.translator.createAsksDocument(this.kbURI);
    }

    private Iterator<DIGQueryResponse> getIterator(Document doc) throws DIGReasonerException {
        return this.translator.getDIGQueryResponseIterator(this.getOWLDataFactory(), doc);
    }

    private static Set<Set<OWLClass>> toClassSet(Iterator<DIGQueryResponse> it) throws DIGReasonerException {
        HashSet<Set<OWLClass>> result = new HashSet<Set<OWLClass>>();
        while (it.hasNext()) {
            result.addAll(it.next().getConceptSets());
        }
        return result;
    }

    private static Set<Set<OWLObjectProperty>> toObjectPropertySet(Iterator<DIGQueryResponse> it) throws DIGReasonerException {
        HashSet<Set<OWLObjectProperty>> result = new HashSet<Set<OWLObjectProperty>>();
        while (it.hasNext()) {
            result.addAll(it.next().getRoleSets());
        }
        return result;
    }

    @Override
    public boolean isConsistent(OWLOntology ontology) throws OWLReasonerException {
        this.synchroniseReasoner();
        return this.isSatisfiable(this.getOWLOntologyManager().getOWLDataFactory().getOWLThing());
    }

    @Override
    public boolean isSatisfiable(OWLDescription cls) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createSatisfiableQuery(doc, "q0", cls);
        return this.getIterator(this.performRequest(doc)).next().getBoolean();
    }

    @Override
    public boolean isSubClassOf(OWLDescription clsC, OWLDescription clsD) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createSubsumesQuery(doc, "q0", clsD, clsC);
        return this.getIterator(this.performRequest(doc)).next().getBoolean();
    }

    @Override
    public boolean isEquivalentClass(OWLDescription clsC, OWLDescription clsD) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createSubsumesQuery(doc, "q0", clsC, clsD);
        this.translator.createSubsumesQuery(doc, "q1", clsD, clsC);
        Iterator<DIGQueryResponse> it = this.getIterator(this.performRequest(doc));
        return it.next().getBoolean() && it.next().getBoolean();
    }

    @Override
    public Set<Set<OWLClass>> getSuperClasses(OWLDescription description) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createDirectSuperConceptsQuery(doc, "q0", description);
        return DIGReasoner.toClassSet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<Set<OWLClass>> getAncestorClasses(OWLDescription description) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createAncestorConceptsQuery(doc, "q0", description);
        return DIGReasoner.toClassSet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<Set<OWLClass>> getSubClasses(OWLDescription description) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createDirectSubConceptsQuery(doc, "q0", description);
        return DIGReasoner.toClassSet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<Set<OWLClass>> getDescendantClasses(OWLDescription description) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createDescendantConceptsQuery(doc, "q0", description);
        return DIGReasoner.toClassSet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<OWLClass> getEquivalentClasses(OWLDescription description) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createEquivalentConceptsQuery(doc, "q0", description);
        Iterator<DIGQueryResponse> it = this.getIterator(this.performRequest(doc));
        HashSet<OWLClass> results = new HashSet<OWLClass>();
        while (it.hasNext()) {
            for (Set<OWLClass> clsSet : it.next().getConceptSets()) {
                results.addAll(clsSet);
            }
        }
        return results;
    }

    @Override
    public Set<OWLClass> getInconsistentClasses() throws OWLReasonerException {
        return this.getEquivalentClasses(this.getOWLOntologyManager().getOWLDataFactory().getOWLNothing());
    }

    @Override
    public Set<Set<OWLClass>> getTypes(OWLIndividual individual, boolean direct) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createIndividualTypesQuery(doc, "q0", individual);
        return DIGReasoner.toClassSet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<OWLIndividual> getIndividuals(OWLDescription clsC, boolean direct) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createInstancesOfConceptQuery(doc, "q0", clsC);
        return this.getIterator(this.performRequest(doc)).next().getIndividuals();
    }

    @Override
    public Map<OWLObjectProperty, Set<OWLIndividual>> getObjectPropertyRelationships(OWLIndividual individual) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Map<OWLDataProperty, Set<OWLConstant>> getDataPropertyRelationships(OWLIndividual individual) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<OWLIndividual> getRelatedIndividuals(OWLIndividual subject, OWLObjectPropertyExpression property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<OWLConstant> getRelatedValues(OWLIndividual subject, OWLDataPropertyExpression property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean hasDataPropertyRelationship(OWLIndividual subject, OWLDataPropertyExpression property, OWLConstant object) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean hasObjectPropertyRelationship(OWLIndividual subject, OWLObjectPropertyExpression property, OWLIndividual object) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean hasType(OWLIndividual individual, OWLDescription type, boolean direct) throws OWLReasonerException {
        return DIGReasoner.flattenSetOfSets(this.getTypes(individual, direct)).contains(type);
    }

    @Override
    public Set<Set<OWLObjectProperty>> getSuperProperties(OWLObjectProperty property) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createDirectSuperPropertiesQuery(doc, "q0", property);
        return DIGReasoner.toObjectPropertySet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<Set<OWLObjectProperty>> getSubProperties(OWLObjectProperty property) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createDirectSubPropertiesQuery(doc, "q0", property);
        return DIGReasoner.toObjectPropertySet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<Set<OWLObjectProperty>> getAncestorProperties(OWLObjectProperty property) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createAncestorPropertiesQuery(doc, "q0", property);
        return DIGReasoner.toObjectPropertySet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<Set<OWLObjectProperty>> getDescendantProperties(OWLObjectProperty property) throws OWLReasonerException {
        this.synchroniseReasoner();
        Document doc = this.createAsksDocument();
        this.translator.createDescendantPropertiesQuery(doc, "q0", property);
        return DIGReasoner.toObjectPropertySet(this.getIterator(this.performRequest(doc)));
    }

    @Override
    public Set<Set<OWLObjectProperty>> getInverseProperties(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<OWLObjectProperty> getEquivalentProperties(OWLObjectProperty property) throws OWLReasonerException {
        Set<OWLObjectProperty> ancestors = DIGReasoner.flattenSetOfSets(this.getAncestorProperties(property));
        Set descendants = DIGReasoner.flattenSetOfSets(this.getDescendantProperties(property));
        ancestors.retainAll(descendants);
        return ancestors;
    }

    @Override
    public Set<Set<OWLDescription>> getDomains(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<OWLDescription> getRanges(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean isFunctional(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean isInverseFunctional(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean isSymmetric(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean isTransitive(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean isReflexive(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean isIrreflexive(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean isAntiSymmetric(OWLObjectProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<Set<OWLDataProperty>> getSuperProperties(OWLDataProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<Set<OWLDataProperty>> getSubProperties(OWLDataProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<Set<OWLDataProperty>> getAncestorProperties(OWLDataProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<Set<OWLDataProperty>> getDescendantProperties(OWLDataProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<OWLDataProperty> getEquivalentProperties(OWLDataProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<Set<OWLDescription>> getDomains(OWLDataProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public Set<OWLDataRange> getRanges(OWLDataProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    @Override
    public boolean isFunctional(OWLDataProperty property) throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }
}

