/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.inference.dig11;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DIGReasonerIdentity {
    private String reasonerName;
    private String reasonerMessage;
    private String reasonerVersion;
    private Set supportedLanguageElements = new HashSet();
    private Set supportedTellElements = new HashSet();
    private Set supportedAskElements = new HashSet();

    protected void clear() {
        this.supportedLanguageElements = new HashSet();
        this.supportedTellElements = new HashSet();
        this.supportedAskElements = new HashSet();
        this.reasonerName = "";
        this.reasonerMessage = "";
        this.reasonerVersion = "";
    }

    public void parseIdentityDescrtiption(Document doc) {
        this.clear();
        this.processDocument(doc);
    }

    protected void processDocument(Document doc) {
        Element docElement = doc.getDocumentElement();
        this.reasonerName = docElement.getAttribute("name");
        this.reasonerMessage = docElement.getAttribute("message");
        this.reasonerVersion = docElement.getAttribute("version");
        if (this.reasonerName.equals("Racer")) {
            this.supportedLanguageElements.add("iset");
            this.supportedLanguageElements.add("individual");
        }
        Element supportsElement = (Element)docElement.getElementsByTagName("supports").item(0);
        Node node = supportsElement.getElementsByTagName("language").item(0);
        this.fillSet(node, this.supportedLanguageElements);
        node = supportsElement.getElementsByTagName("tell").item(0);
        this.fillSet(node, this.supportedTellElements);
        node = supportsElement.getElementsByTagName("ask").item(0);
        this.fillSet(node, this.supportedAskElements);
    }

    public String getName() {
        return this.reasonerName;
    }

    public String getVersion() {
        return this.reasonerVersion;
    }

    public String getMessage() {
        return this.reasonerMessage;
    }

    public Collection getSupportedLanguageElements() {
        return Collections.unmodifiableCollection(this.supportedLanguageElements);
    }

    public Collection getSupportedTellElements() {
        return Collections.unmodifiableCollection(this.supportedTellElements);
    }

    public Collection getSupportedAskElements() {
        return Collections.unmodifiableCollection(this.supportedAskElements);
    }

    public boolean supportsLanguageElement(String constructName) {
        return this.supportedLanguageElements.contains(constructName);
    }

    public boolean supportsTellElemement(String constructName) {
        return this.supportedTellElements.contains(constructName);
    }

    public boolean supportsAskElement(String constructName) {
        return this.supportedAskElements.contains(constructName);
    }

    private void fillSet(Node node, Set set) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            String nodeName = nodeList.item(i).getNodeName();
            set.add(nodeName);
        }
    }
}

