/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.inference.dig11;

import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.manchester.cs.owl.inference.dig11.DIGQueryResponse;
import uk.ac.manchester.cs.owl.inference.dig11.DIGQueryResponseIterator;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasonerException;
import uk.ac.manchester.cs.owl.inference.dig11.DIGRenderer;
import uk.ac.manchester.cs.owl.inference.dig11.DIGTranslator;

public class DIGTranslatorImpl
implements DIGTranslator {
    private OWLOntologyManager manager;
    private DocumentBuilder docBuilder;
    public static final String DL_NAMESPACE = "http://dl.kr.org/dig/2003/02/lang";

    public DIGTranslatorImpl(OWLOntologyManager manager) {
        this.manager = manager;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document createTellsDocument(String kbURI) {
        return this.createDIGDocument("tells", kbURI);
    }

    @Override
    public Document createAsksDocument(String kbURI) {
        return this.createDIGDocument("asks", kbURI);
    }

    @Override
    public Document createDIGDocument(String rootTagName, String kbURI) {
        Document doc = this.createDIGDocument(rootTagName);
        doc.getDocumentElement().setAttribute("uri", kbURI);
        return doc;
    }

    @Override
    public Document createDIGDocument(String rootTagName) {
        Document doc = this.docBuilder.newDocument();
        Element rootElement = doc.createElement(rootTagName);
        rootElement.setAttribute("xmlns", DL_NAMESPACE);
        doc.appendChild(rootElement);
        return doc;
    }

    @Override
    public void translateToDIG(Set<OWLOntology> ontologies, Document doc, Element node) throws DIGReasonerException {
        DIGRenderer render = new DIGRenderer(this.manager, doc, node);
        for (OWLOntology ont : ontologies) {
            ont.accept(render);
        }
    }

    @Override
    public void translateToDIG(OWLObject i, Document doc, Node node) throws DIGReasonerException {
        DIGRenderer render = new DIGRenderer(this.manager, doc, (Element)node);
        i.accept(render);
    }

    @Override
    public Iterator<DIGQueryResponse> getDIGQueryResponseIterator(OWLDataFactory factory, Document doc) throws DIGReasonerException {
        return new DIGQueryResponseIterator(doc, factory);
    }

    protected static Element createQueryElement(Document doc, String name, String queryID) {
        Element element = doc.createElement(name);
        element.setAttribute("id", queryID);
        return element;
    }

    @Override
    public void createAllConceptNamesQuery(Document doc, String queryID) {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "allConceptNames", queryID);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createAllPropertyNamesQuery(Document doc, String queryID) {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "allRoleNames", queryID);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createAllIndividualsQuery(Document doc, String queryID) {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "allIndividuals", queryID);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createSatisfiableQuery(Document doc, String queryID, OWLDescription aClass) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "satisfiable", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createSatisfiableQuery(Document doc, String queryID, Set<OWLDescription> clses) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "satisfiable", queryID);
        Element intersectionElement = doc.createElement("and");
        element.appendChild(intersectionElement);
        for (OWLDescription desc : clses) {
            this.translateToDIG(desc, doc, (Node)intersectionElement);
        }
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createSubsumesQuery(Document doc, String queryID, OWLDescription cls1, OWLDescription cls2) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "subsumes", queryID);
        this.translateToDIG(cls1, doc, (Node)element);
        this.translateToDIG(cls2, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createDisjointQuery(Document doc, String queryID, OWLDescription cls1, OWLDescription cls2) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "disjoint", queryID);
        this.translateToDIG(cls1, doc, (Node)element);
        this.translateToDIG(cls2, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createDirectSuperConceptsQuery(Document doc, String queryID, OWLDescription aClass) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "parents", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createDirectSuperConceptsQuery(Document doc, String queryID, Set<OWLDescription> clses) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "parents", queryID);
        Element andElement = doc.createElement("and");
        element.appendChild(andElement);
        for (OWLDescription desc : clses) {
            this.translateToDIG(desc, doc, (Node)andElement);
        }
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createDirectSubConceptsQuery(Document doc, String queryID, OWLDescription aClass) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "children", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createAncestorConceptsQuery(Document doc, String queryID, OWLDescription aClass) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "ancestors", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createDescendantConceptsQuery(Document doc, String queryID, OWLDescription aClass) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "descendants", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createEquivalentConceptsQuery(Document doc, String queryID, OWLDescription aClass) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "equivalents", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createDirectSuperPropertiesQuery(Document doc, String queryID, OWLObjectProperty property) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "rparents", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createDirectSubPropertiesQuery(Document doc, String queryID, OWLObjectProperty property) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "rchildren", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createAncestorPropertiesQuery(Document doc, String queryID, OWLObjectProperty property) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "rancestors", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createDescendantPropertiesQuery(Document doc, String queryID, OWLObjectProperty property) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "rdescendants", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createInstancesOfConceptQuery(Document doc, String queryID, OWLDescription aClass) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "instances", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createIndividualTypesQuery(Document doc, String queryID, OWLIndividual ins) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "types", queryID);
        this.translateToDIG(ins, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createIndividualInstanceOfConceptQuery(Document doc, String queryID, OWLIndividual ins, OWLDescription aClass) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "instance", queryID);
        this.translateToDIG(ins, doc, (Node)element);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createPropertyFillersQuery(Document doc, String queryID, OWLIndividual ins, OWLObjectProperty property) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "rolefillers", queryID);
        this.translateToDIG(ins, doc, (Node)element);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    @Override
    public void createRelatedIndividualsQuery(Document doc, String queryID, OWLObjectProperty property) throws DIGReasonerException {
        Element element = DIGTranslatorImpl.createQueryElement(doc, "relatedIndividuals", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }
}

