/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.mansyntaxrenderer;

import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.coode.manchesterowlsyntax.ManchesterOWLSyntax;
import org.coode.xml.OWLOntologyNamespaceManager;
import org.semanticweb.owl.io.OWLRendererException;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.util.OWLEntityCollector;
import org.semanticweb.owl.util.ShortFormProvider;
import uk.ac.manchester.cs.owl.mansyntaxrenderer.ManchesterOWLSyntaxObjectRenderer;

public class ManchesterOWLSyntaxFrameRenderer
extends ManchesterOWLSyntaxObjectRenderer
implements OWLEntityVisitor {
    private OWLOntologyNamespaceManager nsm;
    private OWLOntology ontology;

    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, Writer writer) {
        super(writer);
        this.ontology = ontology;
        this.nsm = new OWLOntologyNamespaceManager(owlOntologyManager, ontology);
        this.setShortFormProvider(new ShortFormProvider(){

            @Override
            public String getShortForm(OWLEntity entity) {
                return ManchesterOWLSyntaxFrameRenderer.this.nsm.getQName(entity.getURI().toString());
            }

            @Override
            public void dispose() {
            }
        });
    }

    private OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLOntologyNamespaceManager getNamespaceManager() {
        return this.nsm;
    }

    public void writeOntology() throws OWLRendererException {
        this.writePrefixMap();
        this.writeNewLine();
        this.write(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(":");
        this.writeSpace();
        this.writeFullURI(this.getOntology().getURI().toString());
        this.writeNewLine();
        for (OWLImportsDeclaration decl : this.getOntology().getImportsDeclarations()) {
            this.write(ManchesterOWLSyntax.IMPORT.toString());
            this.write(":");
            this.writeSpace();
            this.writeFullURI(decl.getImportedOntologyURI().toString());
            this.writeNewLine();
        }
        this.writeNewLine();
        HashSet<OWLAnnotation<OWLObject>> annos = new HashSet<OWLAnnotation<OWLObject>>();
        for (OWLOntologyAnnotationAxiom oWLOntologyAnnotationAxiom : this.getOntology().getAnnotations(this.getOntology())) {
            annos.add(oWLOntologyAnnotationAxiom.getAnnotation());
        }
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, annos, ",", true);
        for (OWLObjectProperty oWLObjectProperty : this.getOntology().getReferencedObjectProperties()) {
            this.write(oWLObjectProperty);
            this.writeNewLine();
            this.writeNewLine();
        }
        for (OWLDataProperty oWLDataProperty : this.getOntology().getReferencedDataProperties()) {
            this.write(oWLDataProperty);
            this.writeNewLine();
            this.writeNewLine();
        }
        for (OWLClass oWLClass : this.getOntology().getReferencedClasses()) {
            this.write(oWLClass);
            this.writeNewLine();
            this.writeNewLine();
        }
        for (OWLIndividual oWLIndividual : this.getOntology().getReferencedIndividuals()) {
            this.write(oWLIndividual);
            this.writeNewLine();
            this.writeNewLine();
        }
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : this.getOntology().getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (oWLDisjointClassesAxiom.getDescriptions().size() <= 2) continue;
            this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, oWLDisjointClassesAxiom.getDescriptions(), ",", true);
        }
        this.flush();
    }

    public void writePrefixMap() {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        for (String prefix : this.nsm.getPrefixes()) {
            prefixMap.put(prefix, this.nsm.getNamespaceForPrefix(prefix));
            this.write(ManchesterOWLSyntax.NAMESPACE.toString());
            this.write(":");
            this.writeSpace();
            this.write(prefix);
            this.writeSpace();
            this.writeFullURI(this.nsm.getNamespaceForPrefix(prefix));
            this.writeNewLine();
        }
        if (!prefixMap.isEmpty()) {
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeFullURI(String uri) {
        this.write("<");
        this.write(uri);
        this.write(">");
    }

    @Override
    protected void write(URI uri) {
        String qname = this.nsm.getQName(uri.toString());
        if (qname != null) {
            super.write(qname);
        } else {
            this.writeFullURI(uri.toString());
        }
    }

    public Set<OWLAxiom> write(OWLClass cls) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.CLASS, cls));
        this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, cls.getEquivalentClasses(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getEquivalentClassesAxioms(cls));
        Set<OWLDescription> superclasses = cls.getSuperClasses(this.getOntology());
        if (!superclasses.isEmpty()) {
            this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true);
            axioms.addAll(this.getOntology().getSubClassAxiomsForLHS(cls));
        }
        HashSet<OWLDisjointClassesAxiom> pairwiseDisjointClassesAxioms = new HashSet<OWLDisjointClassesAxiom>();
        HashSet<OWLDescription> disjointClasses = new HashSet<OWLDescription>();
        for (OWLDisjointClassesAxiom ax : this.getOntology().getDisjointClassesAxioms(cls)) {
            if (ax.getDescriptions().size() > 2) continue;
            pairwiseDisjointClassesAxioms.add(ax);
            disjointClasses.addAll(ax.getDescriptions());
        }
        disjointClasses.remove(cls);
        axioms.addAll(pairwiseDisjointClassesAxioms);
        this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, disjointClasses, ",", true);
        this.writeEntitySectionEnd();
        return axioms;
    }

    private void writeEntitySectionEnd() {
        this.popTab();
        this.writeNewLine();
        this.writeNewLine();
    }

    public Set<OWLAxiom> write(OWLObjectProperty property) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.OBJECT_PROPERTY, property));
        ArrayList<String> characteristics = new ArrayList<String>();
        if (property.isFunctional(this.getOntology())) {
            characteristics.add(ManchesterOWLSyntax.FUNCTIONAL.toString());
            axioms.add(this.getOntology().getFunctionalObjectPropertyAxiom(property));
        }
        if (property.isInverseFunctional(this.getOntology())) {
            characteristics.add(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString());
            axioms.add(this.getOntology().getInverseFunctionalObjectPropertyAxiom(property));
        }
        if (property.isSymmetric(this.getOntology())) {
            characteristics.add(ManchesterOWLSyntax.SYMMETRIC.toString());
            axioms.add(this.getOntology().getSymmetricObjectPropertyAxiom(property));
        }
        if (property.isTransitive(this.getOntology())) {
            characteristics.add(ManchesterOWLSyntax.TRANSITIVE.toString());
            axioms.add(this.getOntology().getTransitiveObjectPropertyAxiom(property));
        }
        if (property.isReflexive(this.getOntology())) {
            characteristics.add(ManchesterOWLSyntax.REFLEXIVE.toString());
            axioms.add(this.getOntology().getReflexiveObjectPropertyAxiom(property));
        }
        if (property.isIrreflexive(this.getOntology())) {
            characteristics.add(ManchesterOWLSyntax.IRREFLEXIVE.toString());
            axioms.add(this.getOntology().getIrreflexiveObjectPropertyAxiom(property));
        }
        if (property.isAntiSymmetric(this.getOntology())) {
            characteristics.add(ManchesterOWLSyntax.ANTI_SYMMETRIC.toString());
            axioms.add(this.getOntology().getAntiSymmetricObjectPropertyAxiom(property));
        }
        this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, new LinkedHashSet(characteristics), ",", true);
        this.writeSection(ManchesterOWLSyntax.DOMAIN, property.getDomains(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getObjectPropertyDomainAxioms(property));
        this.writeSection(ManchesterOWLSyntax.RANGE, property.getRanges(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getObjectPropertyRangeAxioms(property));
        this.writeSection(ManchesterOWLSyntax.INVERSE_OF, property.getInverses(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getInverseObjectPropertyAxioms(property));
        this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, property.getSuperProperties(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getObjectSubPropertyAxiomsForLHS(property));
        this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, property.getEquivalentProperties(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getEquivalentObjectPropertiesAxioms(property));
        this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, property.getDisjointProperties(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getDisjointObjectPropertiesAxiom(property));
        for (OWLObjectPropertyChainSubPropertyAxiom ax : this.getOntology().getPropertyChainSubPropertyAxioms()) {
            if (!ax.getSuperProperty().equals(property)) continue;
            this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, new LinkedHashSet<OWLObjectPropertyExpression>(ax.getPropertyChain()), " o ", false);
            axioms.add(ax);
        }
        this.writeEntitySectionEnd();
        return axioms;
    }

    public Set<OWLAxiom> write(OWLDataProperty property) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATA_PROPERTY, property));
        ArrayList<String> characteristics = new ArrayList<String>();
        if (property.isFunctional(this.getOntology())) {
            characteristics.add(ManchesterOWLSyntax.FUNCTIONAL.toString());
            axioms.add(this.getOntology().getFunctionalDataPropertyAxiom(property));
        }
        this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, new LinkedHashSet(characteristics), ",", true);
        this.writeSection(ManchesterOWLSyntax.DOMAIN, property.getDomains(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getDataPropertyDomainAxioms(property));
        this.writeSection(ManchesterOWLSyntax.RANGE, property.getRanges(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getDataPropertyRangeAxiom(property));
        this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, property.getSuperProperties(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getDataSubPropertyAxiomsForLHS(property));
        this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, property.getEquivalentProperties(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getEquivalentDataPropertiesAxiom(property));
        this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, property.getDisjointProperties(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getDisjointDataPropertiesAxiom(property));
        this.writeEntitySectionEnd();
        return axioms;
    }

    public Set<OWLAxiom> write(OWLIndividual individual) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.INDIVIDUAL, individual));
        this.writeSection(ManchesterOWLSyntax.TYPES, individual.getTypes(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getClassAssertionAxioms(individual));
        Map<OWLObjectPropertyExpression, Set<OWLIndividual>> objectMap = individual.getObjectPropertyValues(this.getOntology());
        Map<OWLDataPropertyExpression, Set<OWLConstant>> dataMap = individual.getDataPropertyValues(this.getOntology());
        Map<OWLObjectPropertyExpression, Set<OWLIndividual>> negObjectMap = individual.getNegativeObjectPropertyValues(this.getOntology());
        Map<OWLDataPropertyExpression, Set<OWLConstant>> negDataMap = individual.getNegativeDataPropertyValues(this.getOntology());
        if (!(objectMap.isEmpty() && dataMap.isEmpty() && negObjectMap.isEmpty() && negDataMap.isEmpty())) {
            this.writeSection(ManchesterOWLSyntax.FACTS);
            this.incrementTab(4);
            this.writeNewLine();
            this.writeFacts(objectMap, false);
            if (!(objectMap.isEmpty() || dataMap.isEmpty() && negObjectMap.isEmpty() && negDataMap.isEmpty())) {
                this.write(",");
                this.writeNewLine();
            }
            this.writeFacts(dataMap, false);
            if (!(dataMap.isEmpty() || negObjectMap.isEmpty() && negDataMap.isEmpty())) {
                this.write(",");
                this.writeNewLine();
            }
            this.writeFacts(negObjectMap, true);
            if (!negDataMap.isEmpty() && !negObjectMap.isEmpty()) {
                this.write(",");
                this.writeNewLine();
            }
            this.writeFacts(negDataMap, true);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
        axioms.addAll(this.getOntology().getNegativeDataPropertyAssertionAxioms(individual));
        axioms.addAll(this.getOntology().getNegativeObjectPropertyAssertionAxioms(individual));
        axioms.addAll(this.getOntology().getObjectPropertyAssertionAxioms(individual));
        axioms.addAll(this.getOntology().getDataPropertyAssertionAxioms(individual));
        this.writeSection(ManchesterOWLSyntax.SAME_AS, individual.getSameIndividuals(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getSameIndividualAxioms(individual));
        this.writeSection(ManchesterOWLSyntax.DIFFERENT_FROM, individual.getDifferentIndividuals(this.getOntology()), ",", true);
        axioms.addAll(this.getOntology().getDifferentIndividualAxioms(individual));
        this.writeEntitySectionEnd();
        return axioms;
    }

    private <K extends OWLObject, V extends OWLObject> void writeFacts(Map<K, Set<V>> relationshipsMap, boolean negative) {
        Iterator<K> propIt = relationshipsMap.keySet().iterator();
        while (propIt.hasNext()) {
            OWLObject prop = (OWLObject)propIt.next();
            Iterator<V> it = relationshipsMap.get(prop).iterator();
            while (it.hasNext()) {
                if (negative) {
                    this.write(ManchesterOWLSyntax.NOT);
                    this.writeSpace();
                }
                prop.accept(this);
                this.writeSpace();
                this.writeSpace();
                OWLObject ind = (OWLObject)it.next();
                ind.accept(this);
                if (!it.hasNext()) continue;
                this.write(",");
                this.writeNewLine();
            }
            if (!propIt.hasNext()) continue;
            this.write(",");
            this.writeNewLine();
        }
    }

    private Set<OWLEntityAnnotationAxiom> writeEntityStart(ManchesterOWLSyntax keyword, OWLEntity entity) {
        this.writeSection(keyword);
        entity.accept(this);
        this.writeNewLine();
        this.incrementTab(4);
        this.writeNewLine();
        return this.writeAnnotations(entity);
    }

    public Set<OWLEntityAnnotationAxiom> writeAnnotations(OWLEntity entity) {
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, entity.getAnnotations(this.getOntology()), ",", true);
        return this.getOntology().getEntityAnnotationAxioms(entity);
    }

    public void writeSection(ManchesterOWLSyntax keyword) {
        this.write("", keyword, "");
        this.write(":");
        this.writeSpace();
    }

    public void writeSection(ManchesterOWLSyntax keyword, Set<? extends Object> content, String delimeter, boolean newline) {
        if (!content.isEmpty()) {
            this.writeSection(keyword);
            this.incrementTab(4);
            this.writeNewLine();
            Iterator<? extends Object> it = content.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept(this);
                } else {
                    this.write(obj.toString());
                }
                if (!it.hasNext()) continue;
                this.write(delimeter);
                if (!newline) continue;
                this.writeNewLine();
            }
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    private class EntityDependency
    implements Comparator<OWLEntity> {
        private OWLOntology ont;
        private Set<Set<OWLEntity>> cyclicDependencies;

        public EntityDependency(OWLOntology ont) {
            this.ont = ont;
            this.cyclicDependencies = new HashSet<Set<OWLEntity>>();
        }

        public Set<Set<OWLEntity>> getCyclicDependencies() {
            return this.cyclicDependencies;
        }

        @Override
        public int compare(OWLEntity o1, OWLEntity o2) {
            Set<Object> axioms1 = Collections.emptySet();
            if (o1.isOWLClass()) {
                axioms1 = this.ont.getAxioms(o1.asOWLClass());
            } else if (o1.isOWLObjectProperty()) {
                axioms1 = this.ont.getAxioms(o1.asOWLObjectProperty());
            } else if (o1.isOWLDataProperty()) {
                axioms1 = this.ont.getAxioms(o1.asOWLDataProperty());
            } else if (o1.isOWLIndividual()) {
                axioms1 = this.ont.getAxioms(o1.asOWLIndividual());
            }
            OWLEntityCollector collector1 = new OWLEntityCollector();
            for (OWLAxiom ax1 : axioms1) {
                ax1.accept(collector1);
            }
            Set<OWLEntity> dependents1 = collector1.getObjects();
            dependents1.remove(o1);
            Set<Object> axioms2 = Collections.emptySet();
            if (o1.isOWLClass()) {
                axioms2 = this.ont.getAxioms(o2.asOWLClass());
            } else if (o1.isOWLObjectProperty()) {
                axioms2 = this.ont.getAxioms(o2.asOWLObjectProperty());
            } else if (o1.isOWLDataProperty()) {
                axioms2 = this.ont.getAxioms(o2.asOWLDataProperty());
            } else if (o1.isOWLIndividual()) {
                axioms2 = this.ont.getAxioms(o2.asOWLIndividual());
            }
            OWLEntityCollector collector2 = new OWLEntityCollector();
            for (OWLAxiom ax2 : axioms2) {
                ax2.accept(collector2);
            }
            Set<OWLEntity> dependents2 = collector2.getObjects();
            dependents2.remove(o2);
            if (dependents1.contains(o2)) {
                if (dependents2.contains(o1)) {
                    this.cyclicDependencies.add(CollectionFactory.createSet(o1, o2));
                    return 0;
                }
                return -1;
            }
            if (dependents2.contains(o1)) {
                return 1;
            }
            return -1;
        }
    }
}

