/*
 * Decompiled with CFR 0.152.
 */
package es.isa.emma.sme2;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import de.dfki.sme2.IMatchmakerPlugin;
import de.dfki.sme2.Matchmaker;
import es.isa.emma.sme2.InternalMatchmakerThread;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;

public abstract class FilteringMatchmakerPlugin
implements IMatchmakerPlugin {
    private IMatchmakerPlugin internalMatchmaker;
    private OntModel repository;
    private List<URL> addedServices;
    private final String SME2_PLUGINS_DIR = "plugin/";
    private Logger logger = Logger.getLogger(FilteringMatchmakerPlugin.class);

    public FilteringMatchmakerPlugin(String internalMatchmakerPath) {
        this.internalMatchmaker = Matchmaker.parse((String)("plugin/" + internalMatchmakerPath)).getPluginInstance();
        this.repository = ModelFactory.createOntologyModel();
        this.addedServices = new ArrayList<URL>();
        this.logger.info((Object)("---- New filtering ---- " + this.getClass().getName()));
    }

    public void input(URL serviceUrl) {
        try {
            this.repository.read(serviceUrl.toString());
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unable to read service " + serviceUrl.toString()), (Throwable)e);
        }
        this.addedServices.add(serviceUrl);
        Collections.shuffle(this.addedServices);
    }

    public Hashtable<URL, Vector<URL>> query(URL queryUrl) {
        Hashtable<URL, Vector<URL>> hash = new Hashtable<URL, Vector<URL>>();
        ArrayList<URL> relatedServices = new ArrayList<URL>();
        String sparqlQuery = this.generateSPARQLQuery(queryUrl);
        if (sparqlQuery == null) {
            return hash;
        }
        this.logger.debug((Object)sparqlQuery);
        Query jenaQuery = QueryFactory.create((String)sparqlQuery, (String)"http://127.0.0.1/", (Syntax)Syntax.syntaxSPARQL);
        QueryExecution qexec = QueryExecutionFactory.create((Query)jenaQuery, (Model)this.repository);
        ResultSet resultSet = qexec.execSelect();
        while (resultSet.hasNext()) {
            try {
                QuerySolution sol = resultSet.nextSolution();
                Resource serviceUri = (Resource)sol.get("s").as(Resource.class);
                String trimmedServiceUri = serviceUri.getURI().toString();
                int sharpIndex = trimmedServiceUri.indexOf("#");
                if (sharpIndex > -1) {
                    trimmedServiceUri = trimmedServiceUri.substring(0, sharpIndex);
                }
                relatedServices.add(new URL(trimmedServiceUri));
            }
            catch (MalformedURLException e) {
                this.logger.error((Object)"Error processing SPARQL results", (Throwable)e);
            }
        }
        qexec.close();
        this.logger.info((Object)(String.valueOf(queryUrl.toString()) + " -> " + relatedServices.size()));
        InternalMatchmakerThread mmThread = new InternalMatchmakerThread(this.internalMatchmaker, relatedServices, this.addedServices, queryUrl);
        mmThread.start();
        try {
            mmThread.join();
        }
        catch (InterruptedException e1) {
            this.logger.warn((Object)"Internal matchmaker thread interrupted", (Throwable)e1);
        }
        return mmThread.getResultHash();
    }

    public abstract String generateSPARQLQuery(URL var1);

    protected void addCommonPrefixes(StringBuffer query) {
        query.append(" PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#> ");
        query.append(" PREFIX xsd:<http://www.w3.org/2001/XMLSchema#> ");
        query.append(" PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#> ");
        query.append(" PREFIX owl:<http://www.w3.org/2002/07/owl#> ");
        query.append(" PREFIX service:<http://www.daml.org/services/owl-s/1.1/Service.owl#> ");
        query.append(" PREFIX process:<http://www.daml.org/services/owl-s/1.1/Process.owl#> ");
        query.append(" PREFIX profile:<http://www.daml.org/services/owl-s/1.1/Profile.owl#> ");
        query.append(" PREFIX grounding:<http://www.daml.org/services/owl-s/1.1/Grounding.owl#> ");
        query.append(" SELECT DISTINCT ?s WHERE { ");
        query.append(" ?s rdf:type service:Service. ");
        query.append(" ?s service:presents ?prof. ");
    }

    protected Set<String> getRelatedClassSet(OWLType type, OWLKnowledgeBase kb) {
        HashSet<String> classSet = new HashSet<String>();
        if (type instanceof OWLClass) {
            OWLClass clazz = (OWLClass)type;
            Set subClasses = kb.getSubClasses(clazz, false);
            for (OWLClass subClass : subClasses) {
                classSet.add(subClass.getURI().toString());
            }
            classSet.add(clazz.getURI().toString());
        } else {
            classSet.add(type.getURI().toString());
        }
        return classSet;
    }
}

