/*
 * Decompiled with CFR 0.152.
 */
package es.isa.emma.sme2;

import de.dfki.sme2.IMatchmakerPlugin;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InternalMatchmakerThread
extends Thread {
    private IMatchmakerPlugin plugin;
    private List<URL> relatedServices;
    private Hashtable<URL, Vector<URL>> resultHash;
    private List<URL> notYetRegisteredServices;
    private URL queryUrl;
    private Logger logger = Logger.getLogger(InternalMatchmakerThread.class);

    public InternalMatchmakerThread(IMatchmakerPlugin plugin, List<URL> relatedServices, List<URL> addedServices, URL queryUrl) {
        this.plugin = plugin;
        this.relatedServices = relatedServices;
        this.notYetRegisteredServices = addedServices;
        this.queryUrl = queryUrl;
        this.resultHash = new Hashtable();
    }

    @Override
    public void run() {
        try {
            for (URL service : this.relatedServices) {
                try {
                    if (!this.notYetRegisteredServices.contains(service)) continue;
                    this.plugin.input(service);
                    this.notYetRegisteredServices.remove(service);
                }
                catch (Exception e) {
                    this.logger.warn((Object)("[InternalMatchmaker] Unable to register service " + service.toString()), (Throwable)e);
                }
            }
            this.resultHash.putAll(this.plugin.query(this.queryUrl));
            Vector<URL> queryResult = this.resultHash.get(this.queryUrl);
            if (queryResult != null) {
                this.resultHash.get(this.queryUrl).addAll(this.notYetRegisteredServices);
            } else {
                queryResult = new Vector();
                queryResult.addAll(this.relatedServices);
                queryResult.addAll(this.notYetRegisteredServices);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Internal matchmaker thread evaluation error", (Throwable)e);
        }
    }

    public Hashtable<URL, Vector<URL>> getResultHash() {
        return this.resultHash;
    }
}

