/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ChoicePointContext;
import alice.tuprolog.Engine;
import alice.tuprolog.Struct;
import alice.tuprolog.SubGoalId;
import alice.tuprolog.SubGoalStore;
import alice.util.OneWayList;
import java.util.ArrayList;
import java.util.List;

public class ExecutionContext {
    private int id;
    int depth;
    Struct currentGoal;
    ExecutionContext fatherCtx;
    SubGoalId fatherGoalId;
    Struct clause;
    Struct headClause;
    SubGoalStore goalsToEval;
    OneWayList trailingVars;
    OneWayList fatherVarsList;
    ChoicePointContext choicePointAfterCut;
    boolean haveAlternatives;

    ExecutionContext(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return "\t     id: " + this.id + "\n" + "     currentGoal:  " + this.currentGoal + "\n" + "     clause:       " + this.clause + "\n" + "     subGoalStore: " + this.goalsToEval + "\n" + "     trailingVars: " + this.trailingVars + "\n" + "";
    }

    public int getDepth() {
        return this.depth;
    }

    public Struct getCurrentGoal() {
        return this.currentGoal;
    }

    public SubGoalId getFatherGoalId() {
        return this.fatherGoalId;
    }

    public Struct getClause() {
        return this.clause;
    }

    public Struct getHeadClause() {
        return this.headClause;
    }

    public SubGoalStore getSubGoalStore() {
        return this.goalsToEval;
    }

    public List getTrailingVars() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (OneWayList oneWayList = this.trailingVars; oneWayList != null; oneWayList = oneWayList.getTail()) {
            arrayList.add(oneWayList.getHead());
        }
        return arrayList;
    }

    void saveParentState() {
        if (this.fatherCtx != null) {
            this.fatherGoalId = this.fatherCtx.goalsToEval.getCurrentGoalId();
            this.fatherVarsList = this.fatherCtx.trailingVars;
        }
    }

    void performTailRecursionOptimization(Engine engine) {
        this.fatherCtx = !this.haveAlternatives && !this.goalsToEval.haveSubGoals() ? engine.currentContext.fatherCtx : engine.currentContext;
    }
}

