/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.test.AbstractExplanationTest;
import com.clarkparsia.owlapi.OntologyUtils;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.coode.owl.rdf.turtle.TurtleOntologyFormat;
import org.junit.Assert;
import org.junit.Assume;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLOntologyOutputTarget;
import org.semanticweb.owl.io.StringInputSource;
import org.semanticweb.owl.io.StringOutputTarget;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaExplanationTest
extends AbstractExplanationTest {
    private static final Logger log = Logger.getLogger(JenaExplanationTest.class.getName());
    private PelletInfGraph pellet;

    public JenaExplanationTest() {
        super(false);
    }

    private Graph convertOntology(Collection<OWLAxiom> axioms, boolean filterTypes) throws Exception {
        return this.convertOntology(OntologyUtils.getOntologyFromAxioms(axioms), filterTypes);
    }

    private Graph convertOntology(OWLOntology ontology, boolean filterTypes) throws Exception {
        StringOutputTarget output = new StringOutputTarget();
        manager.saveOntology(ontology, (OWLOntologyFormat)new TurtleOntologyFormat(), (OWLOntologyOutputTarget)output);
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)new StringReader(output.toString()), ontologyURI.toString(), "TTL");
        if (filterTypes) {
            Resource[] builtinTypes;
            for (Resource builtinType : builtinTypes = new Resource[]{OWL.Ontology, OWL.Class, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.Thing}) {
                model.removeAll(null, RDF.type, (RDFNode)builtinType);
            }
        }
        return model.getGraph();
    }

    @Override
    public KnowledgeBase createKB(OWLOntology ontology) throws Exception {
        Graph data = this.convertOntology(ontology, false);
        Reasoner reasoner = PelletReasonerFactory.theInstance().create();
        this.pellet = (PelletInfGraph)reasoner.bind(data);
        return this.pellet.getKB();
    }

    @Override
    public void testExplanations(OWLAxiom axiom, int max, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        Graph graph = this.convertOntology(Collections.singletonList(axiom), true);
        Assume.assumeTrue((graph.size() == 1 ? 1 : 0) != 0);
        Triple triple = (Triple)graph.find((TripleMatch)Triple.ANY).next();
        Graph actual = this.pellet.explain(triple);
        Assert.assertNotNull((String)("Triple " + triple + "cannot be explained"), (Object)actual);
        boolean success = this.testExplanationWithJena(triple, actual, expectedExplanations);
        Assert.assertTrue((String)"Error in explanation, see the log file for details", (boolean)success);
    }

    private boolean testExplanationWithJena(Triple triple, Graph actual, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        boolean success = true;
        for (Set<OWLAxiom> expectedExplanation : expectedExplanations) {
            Graph expected = this.convertOntology(expectedExplanation, true);
            if (!expected.isIsomorphicWith(actual)) continue;
            success = true;
            break;
        }
        if (!success) {
            StringWriter sw = new StringWriter();
            sw.getBuffer().append("\nTriple: " + triple);
            sw.getBuffer().append("\nExpected (" + expectedExplanations.size() + "):\n");
            for (Set<OWLAxiom> expectedExplanation : expectedExplanations) {
                Graph expected = this.convertOntology(OntologyUtils.getOntologyFromAxioms(expectedExplanation), true);
                ModelFactory.createModelForGraph((Graph)expected).write((Writer)sw, "TTL");
                sw.getBuffer().append("\n=====================");
            }
            sw.getBuffer().append("\nActual:\n");
            Model m = ModelFactory.createModelForGraph((Graph)actual);
            m.setNsPrefixes(PrefixMapping.Extended);
            m.setNsPrefix("swrl", "http://www.w3.org/2003/11/swrl#");
            m.write((Writer)sw, "TTL");
            log.severe("Error in explanation: " + sw);
        }
        return success;
    }

    private boolean testExplanationWithOWLAPI(Triple triple, Graph actual, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        boolean success = true;
        Assert.assertEquals((String)"Multiple explanations cannot be tested", (long)1L, (long)expectedExplanations.size());
        Set<OWLAxiom> expectedExplanation = expectedExplanations.iterator().next();
        StringWriter sw = new StringWriter();
        ModelFactory.createModelForGraph((Graph)actual).write((OutputStream)System.out, "TTL");
        ModelFactory.createModelForGraph((Graph)actual).write((Writer)sw, "RDF/XML");
        OWLOntology ont = manager.loadOntology((OWLOntologyInputSource)new StringInputSource(sw.toString()));
        Set actualExplanation = ont.getLogicalAxioms();
        System.out.println(actualExplanation);
        StringBuilder sb = new StringBuilder();
        sb.append("\nTriple: " + triple);
        sb.append("\nUnexpected :\n");
        for (OWLAxiom actualAxiom : actualExplanation) {
            if (expectedExplanation.remove(actualAxiom)) continue;
            success = false;
            sb.append(actualAxiom);
        }
        sb.append("\nNot found:\n");
        for (OWLAxiom expectedAxiom : expectedExplanation) {
            success = false;
            sb.append(expectedAxiom);
        }
        if (!success) {
            log.severe("Error in explanation: " + sb);
        }
        return success;
    }

    public static void main(String[] args) throws Exception {
        JenaExplanationTest test = new JenaExplanationTest();
        test.createEntities();
        test.multipleDatatypeRange();
    }
}

