/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.BlackBoxExplanation;
import com.clarkparsia.explanation.ExplanationGenerator;
import com.clarkparsia.explanation.GlassBoxExplanation;
import com.clarkparsia.explanation.HSTExplanationGenerator;
import com.clarkparsia.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.explanation.test.AbstractExplanationTest;
import com.clarkparsia.explanation.test.ExplanationTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class OWLAPIExplanationTest
extends AbstractExplanationTest {
    private Reasoner reasoner;
    private Class<? extends TransactionAwareSingleExpGen> expGenClass;
    private HSTExplanationGenerator hst;
    private ExplanationTester tester;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{GlassBoxExplanation.class, false});
        parameters.add(new Object[]{GlassBoxExplanation.class, true});
        parameters.add(new Object[]{BlackBoxExplanation.class, false});
        parameters.add(new Object[]{BlackBoxExplanation.class, true});
        return parameters;
    }

    public OWLAPIExplanationTest(Class<? extends TransactionAwareSingleExpGen> expGenClass, boolean classify) {
        super(classify);
        this.expGenClass = expGenClass;
    }

    @Override
    public KnowledgeBase createKB(OWLOntology ontology) throws Exception {
        PelletReasonerFactory pelletFactory = new PelletReasonerFactory();
        TransactionAwareSingleExpGen singleExpGen = this.expGenClass.getConstructor(OWLOntologyManager.class).newInstance(manager);
        this.reasoner = pelletFactory.createReasoner(manager);
        this.reasoner.loadOntology(ontology);
        this.hst = new HSTExplanationGenerator(singleExpGen);
        this.hst.setReasonerFactory((OWLReasonerFactory)pelletFactory);
        this.hst.setReasoner((OWLClassReasoner)this.reasoner);
        this.hst.setOntology(ontology);
        this.tester = new ExplanationTester((ExplanationGenerator)this.hst);
        return this.reasoner.getKB();
    }

    @Override
    public void testExplanations(OWLAxiom axiom, int max, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        this.tester.testExplanations(axiom, max, expectedExplanations);
    }

    public static void main(String[] args) throws Exception {
        GlassBoxExplanation.log.setLevel(Level.FINER);
        ABox.log.setLevel(Level.FINER);
        OWLAPIExplanationTest test = new OWLAPIExplanationTest(GlassBoxExplanation.class, true);
        test.createEntities();
        test.multipleDatatypeRange();
    }
}

