/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapi.OWL;
import java.util.Arrays;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;

public abstract class AbstractIncrementalClassifierTest
extends AbstractModularityTest {
    private void updateTest(OWLAxiom[] axioms, OWLAxiom[] additions, OWLAxiom[] deletions) throws OWLException {
        this.createOntology(axioms);
        TestUtils.runUpdateTest(this.ontology, this.createModuleExtractor(), Arrays.asList(additions), Arrays.asList(deletions));
    }

    @Test
    public void unsatisfiableTest1() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)OWL.Thing)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void unsatisfiableTest2() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)OWL.Thing)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.B, (OWLDescription)OWL.not((OWLDescription)this.A))};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void indirectSubClassTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C)), OWL.equivalentClasses((OWLDescription)this.B, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.D)), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.E, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.F, (OWLDescription)this.E)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.C)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void leafAddTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.A)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void makeSatisfiable() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.C), OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void annotationOnlyTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.label((OWLEntity)this.B, (String)"B label")};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void internalAddTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)OWL.Thing)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.B, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.B)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void internalDeleteTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.B)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.B, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.B)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void internalMergeTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.E, (OWLDescription)this.B)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.C)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void internalSplitTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.E, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.C)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.C)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void addAndRename() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)OWL.Thing)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.declaration((OWLEntity)this.C), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.A), OWL.declaration((OWLEntity)this.D), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.A)};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.declaration((OWLEntity)this.C), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.A)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void switchSubTreeTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)this.E, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.F, (OWLDescription)this.E), OWL.subClassOf((OWLDescription)this.G, (OWLDescription)this.F)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.E), OWL.subClassOf((OWLDescription)this.F, (OWLDescription)this.B)};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.F, (OWLDescription)this.E)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void indirectModuleTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{this.B, this.C, OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C)})), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)OWL.or((OWLDescription[])new OWLDescription[]{OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)OWL.not((OWLDescription)this.C)), this.D})), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.E)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.not((OWLDescription)this.E))};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void deleteAllAxiomsInModuleTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C))};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void deleteUnsatisfiable() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.C), OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.C)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void addNonLocal() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.declaration((OWLEntity)this.A)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.equivalentClasses((OWLDescription)this.B, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B))};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void deleteNonLocal() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.C)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.C, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B))};
        this.updateTest(axioms, additions, deletions);
    }
}

